/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.transport.controlmessage;

import io.zeebe.protocol.Protocol;
import io.zeebe.protocol.clientapi.ControlMessageResponseEncoder;
import io.zeebe.protocol.clientapi.MessageHeaderEncoder;
import io.zeebe.transport.ServerOutput;
import io.zeebe.transport.ServerResponse;
import io.zeebe.util.buffer.BufferWriter;
import java.util.Objects;
import org.agrona.MutableDirectBuffer;

public class ControlMessageResponseWriter
implements BufferWriter {
    protected final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    protected final ControlMessageResponseEncoder responseEncoder = new ControlMessageResponseEncoder();
    protected BufferWriter dataWriter;
    protected final ServerOutput output;
    protected final ServerResponse response = new ServerResponse();

    public ControlMessageResponseWriter(ServerOutput output) {
        this.output = output;
    }

    public ControlMessageResponseWriter dataWriter(BufferWriter writer) {
        this.dataWriter = writer;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryWriteResponse(int requestStreamId, long requestId) {
        Objects.requireNonNull(this.dataWriter);
        try {
            this.response.reset().remoteStreamId(requestStreamId).requestId(requestId).writer((BufferWriter)this);
            boolean bl = this.output.sendResponse(this.response);
            return bl;
        }
        finally {
            this.reset();
        }
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.messageHeaderEncoder.wrap(buffer, offset).blockLength(this.responseEncoder.sbeBlockLength()).templateId(this.responseEncoder.sbeTemplateId()).schemaId(this.responseEncoder.sbeSchemaId()).version(this.responseEncoder.sbeSchemaVersion());
        this.responseEncoder.wrap(buffer, offset += this.messageHeaderEncoder.encodedLength());
        int dataLength = this.dataWriter.getLength();
        buffer.putShort(offset, (short)dataLength, Protocol.ENDIANNESS);
        this.dataWriter.write(buffer, offset += ControlMessageResponseEncoder.dataHeaderLength());
    }

    public int getLength() {
        return 8 + ControlMessageResponseEncoder.dataHeaderLength() + this.dataWriter.getLength();
    }

    protected void reset() {
        this.dataWriter = null;
    }
}

