/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.transport.controlmessage;

import io.zeebe.broker.task.CreditsRequest;
import io.zeebe.broker.task.TaskSubscriptionManager;
import io.zeebe.broker.task.processor.TaskSubscriptionRequest;
import io.zeebe.broker.transport.clientapi.ErrorResponseWriter;
import io.zeebe.broker.transport.controlmessage.ControlMessageHandler;
import io.zeebe.broker.transport.controlmessage.ControlMessageResponseWriter;
import io.zeebe.protocol.clientapi.ControlMessageType;
import io.zeebe.protocol.clientapi.ErrorCode;
import io.zeebe.protocol.impl.BrokerEventMetadata;
import io.zeebe.transport.ServerOutput;
import io.zeebe.util.buffer.BufferWriter;
import java.util.concurrent.CompletableFuture;
import org.agrona.DirectBuffer;

public class IncreaseTaskSubscriptionCreditsHandler
implements ControlMessageHandler {
    protected static final CompletableFuture<Void> COMPLETED_FUTURE = CompletableFuture.completedFuture(null);
    protected final TaskSubscriptionRequest subscription = new TaskSubscriptionRequest();
    protected final CreditsRequest creditsRequest = new CreditsRequest();
    protected final TaskSubscriptionManager manager;
    protected final ControlMessageResponseWriter responseWriter;
    protected final ErrorResponseWriter errorResponseWriter;

    public IncreaseTaskSubscriptionCreditsHandler(ServerOutput output, TaskSubscriptionManager manager) {
        this.errorResponseWriter = new ErrorResponseWriter(output);
        this.responseWriter = new ControlMessageResponseWriter(output);
        this.manager = manager;
    }

    @Override
    public ControlMessageType getMessageType() {
        return ControlMessageType.INCREASE_TASK_SUBSCRIPTION_CREDITS;
    }

    @Override
    public CompletableFuture<Void> handle(DirectBuffer buffer, BrokerEventMetadata eventMetadata) {
        this.subscription.reset();
        this.subscription.wrap(buffer);
        if (this.subscription.getCredits() <= 0) {
            this.sendError(eventMetadata, buffer, "Cannot increase task subscription credits. Credits must be positive.");
            return COMPLETED_FUTURE;
        }
        this.creditsRequest.setCredits(this.subscription.getCredits());
        this.creditsRequest.setSubscriberKey(this.subscription.getSubscriberKey());
        boolean success = this.manager.increaseSubscriptionCreditsAsync(this.creditsRequest);
        if (success) {
            boolean responseScheduled = this.responseWriter.dataWriter((BufferWriter)this.subscription).tryWriteResponse(eventMetadata.getRequestStreamId(), eventMetadata.getRequestId());
            return COMPLETED_FUTURE;
        }
        this.sendError(eventMetadata, buffer, "Cannot increase task subscription credits. Capacities exhausted.");
        return COMPLETED_FUTURE;
    }

    protected void sendError(BrokerEventMetadata metadata, DirectBuffer request, String errorMessage) {
        boolean success = this.errorResponseWriter.errorCode(ErrorCode.REQUEST_PROCESSING_FAILURE).errorMessage(errorMessage).failedRequest(request, 0, request.capacity()).tryWriteResponseOrLogFailure(metadata.getRequestStreamId(), metadata.getRequestId());
    }
}

