/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.transport.controlmessage;

import io.zeebe.broker.task.TaskSubscriptionManager;
import io.zeebe.broker.task.processor.TaskSubscriptionRequest;
import io.zeebe.broker.transport.clientapi.ErrorResponseWriter;
import io.zeebe.broker.transport.controlmessage.ControlMessageHandler;
import io.zeebe.broker.transport.controlmessage.ControlMessageResponseWriter;
import io.zeebe.protocol.clientapi.ControlMessageType;
import io.zeebe.protocol.clientapi.ErrorCode;
import io.zeebe.protocol.impl.BrokerEventMetadata;
import io.zeebe.transport.ServerOutput;
import io.zeebe.util.buffer.BufferWriter;
import java.util.concurrent.CompletableFuture;
import org.agrona.DirectBuffer;

public class RemoveTaskSubscriptionHandler
implements ControlMessageHandler {
    protected final TaskSubscriptionRequest subscription = new TaskSubscriptionRequest();
    protected final TaskSubscriptionManager manager;
    protected final ControlMessageResponseWriter responseWriter;
    protected final ErrorResponseWriter errorResponseWriter;

    public RemoveTaskSubscriptionHandler(ServerOutput output, TaskSubscriptionManager manager) {
        this.errorResponseWriter = new ErrorResponseWriter(output);
        this.responseWriter = new ControlMessageResponseWriter(output);
        this.manager = manager;
    }

    @Override
    public ControlMessageType getMessageType() {
        return ControlMessageType.REMOVE_TASK_SUBSCRIPTION;
    }

    @Override
    public CompletableFuture<Void> handle(DirectBuffer buffer, BrokerEventMetadata eventMetada) {
        this.subscription.reset();
        this.subscription.wrap(buffer);
        CompletableFuture<Void> future = this.manager.removeSubscription(this.subscription.getSubscriberKey());
        return future.handle((v, failure) -> {
            if (failure == null) {
                boolean bl = this.responseWriter.dataWriter((BufferWriter)this.subscription).tryWriteResponse(eventMetada.getRequestStreamId(), eventMetada.getRequestId());
            } else {
                boolean bl = this.errorResponseWriter.errorCode(ErrorCode.REQUEST_PROCESSING_FAILURE).errorMessage("Cannot remove task subscription. %s", failure.getMessage()).failedRequest(buffer, 0, buffer.capacity()).tryWriteResponseOrLogFailure(eventMetada.getRequestStreamId(), eventMetada.getRequestId());
            }
            return null;
        });
    }
}

