/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.workflow;

import io.zeebe.broker.incident.IncidentStreamProcessorErrorHandler;
import io.zeebe.broker.incident.processor.IncidentStreamProcessor;
import io.zeebe.broker.logstreams.LogStreamServiceNames;
import io.zeebe.broker.logstreams.processor.StreamProcessorService;
import io.zeebe.broker.system.ConfigurationManager;
import io.zeebe.broker.system.SystemServiceNames;
import io.zeebe.broker.transport.clientapi.CommandResponseWriter;
import io.zeebe.broker.workflow.WorkflowCfg;
import io.zeebe.broker.workflow.WorkflowQueueManager;
import io.zeebe.broker.workflow.WorkflowQueueServiceNames;
import io.zeebe.broker.workflow.processor.DeploymentStreamProcessor;
import io.zeebe.broker.workflow.processor.WorkflowInstanceStreamProcessor;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.processor.StreamProcessorController;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceGroupReference;
import io.zeebe.servicecontainer.ServiceName;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.transport.ServerTransport;
import io.zeebe.util.DeferredCommandContext;
import io.zeebe.util.EnsureUtil;
import io.zeebe.util.actor.Actor;
import io.zeebe.util.actor.ActorReference;
import io.zeebe.util.actor.ActorScheduler;

public class WorkflowQueueManagerService
implements Service<WorkflowQueueManager>,
WorkflowQueueManager,
Actor {
    protected static final String NAME = "workflow.queue.manager";
    protected final Injector<ServerTransport> clientApiTransportInjector = new Injector();
    protected final Injector<ActorScheduler> actorSchedulerInjector = new Injector();
    protected final ServiceGroupReference<LogStream> logStreamsGroupReference = ServiceGroupReference.create().onAdd((name, stream) -> this.addStream((LogStream)stream, (ServiceName<LogStream>)name)).build();
    protected ServiceStartContext serviceContext;
    protected DeferredCommandContext asyncContext;
    protected WorkflowCfg workflowCfg;
    protected ActorReference actorRef;

    public WorkflowQueueManagerService(ConfigurationManager configurationManager) {
        this.workflowCfg = configurationManager.readEntry("workflow", WorkflowCfg.class);
    }

    @Override
    public void startWorkflowQueue(LogStream logStream) {
        EnsureUtil.ensureNotNull((String)"logStream", (Object)logStream);
        this.installDeploymentStreamProcessor(logStream.getLogName());
        this.installWorkflowStreamProcessor(logStream);
        this.installIncidentStreamProcessor(logStream);
    }

    private void installDeploymentStreamProcessor(String logName) {
        ServiceName<StreamProcessorController> streamProcessorServiceName = WorkflowQueueServiceNames.deploymentStreamProcessorServiceName(logName);
        String streamProcessorName = streamProcessorServiceName.getName();
        ServerTransport transport = (ServerTransport)this.clientApiTransportInjector.getValue();
        CommandResponseWriter responseWriter = new CommandResponseWriter(transport.getOutput());
        ServiceName<LogStream> logStreamServiceName = LogStreamServiceNames.logStreamServiceName(logName);
        DeploymentStreamProcessor deploymentStreamProcessor = new DeploymentStreamProcessor(responseWriter);
        StreamProcessorService deploymentStreamProcessorService = new StreamProcessorService(streamProcessorName, 60, deploymentStreamProcessor).eventFilter(DeploymentStreamProcessor.eventFilter());
        this.serviceContext.createService(streamProcessorServiceName, (Service)deploymentStreamProcessorService).dependency(logStreamServiceName, deploymentStreamProcessorService.getSourceStreamInjector()).dependency(logStreamServiceName, deploymentStreamProcessorService.getTargetStreamInjector()).dependency(LogStreamServiceNames.SNAPSHOT_STORAGE_SERVICE, deploymentStreamProcessorService.getSnapshotStorageInjector()).dependency(SystemServiceNames.ACTOR_SCHEDULER_SERVICE, deploymentStreamProcessorService.getActorSchedulerInjector()).install();
    }

    private void installWorkflowStreamProcessor(LogStream logStream) {
        ServiceName<StreamProcessorController> streamProcessorServiceName = WorkflowQueueServiceNames.workflowInstanceStreamProcessorServiceName(logStream.getLogName());
        String streamProcessorName = streamProcessorServiceName.getName();
        ServerTransport transport = (ServerTransport)this.clientApiTransportInjector.getValue();
        CommandResponseWriter responseWriter = new CommandResponseWriter(transport.getOutput());
        ServiceName<LogStream> logStreamServiceName = LogStreamServiceNames.logStreamServiceName(logStream.getLogName());
        IncidentStreamProcessorErrorHandler errorHandler = new IncidentStreamProcessorErrorHandler(logStream);
        WorkflowInstanceStreamProcessor workflowInstanceStreamProcessor = new WorkflowInstanceStreamProcessor(responseWriter, this.workflowCfg.deploymentCacheSize, this.workflowCfg.payloadCacheSize);
        StreamProcessorService workflowStreamProcessorService = new StreamProcessorService(streamProcessorName, 70, workflowInstanceStreamProcessor).eventFilter(WorkflowInstanceStreamProcessor.eventFilter()).errorHandler(errorHandler);
        this.serviceContext.createService(streamProcessorServiceName, (Service)workflowStreamProcessorService).dependency(logStreamServiceName, workflowStreamProcessorService.getSourceStreamInjector()).dependency(logStreamServiceName, workflowStreamProcessorService.getTargetStreamInjector()).dependency(LogStreamServiceNames.SNAPSHOT_STORAGE_SERVICE, workflowStreamProcessorService.getSnapshotStorageInjector()).dependency(SystemServiceNames.ACTOR_SCHEDULER_SERVICE, workflowStreamProcessorService.getActorSchedulerInjector()).install();
    }

    private void installIncidentStreamProcessor(LogStream logStream) {
        ServiceName<StreamProcessorController> streamProcessorServiceName = WorkflowQueueServiceNames.incidentStreamProcessorServiceName(logStream.getLogName());
        String streamProcessorName = streamProcessorServiceName.getName();
        ServiceName<LogStream> logStreamServiceName = LogStreamServiceNames.logStreamServiceName(logStream.getLogName());
        IncidentStreamProcessor incidentStreamProcessor = new IncidentStreamProcessor();
        StreamProcessorService incidentStreamProcessorService = new StreamProcessorService(streamProcessorName, 80, incidentStreamProcessor).eventFilter(IncidentStreamProcessor.eventFilter());
        this.serviceContext.createService(streamProcessorServiceName, (Service)incidentStreamProcessorService).dependency(logStreamServiceName, incidentStreamProcessorService.getSourceStreamInjector()).dependency(logStreamServiceName, incidentStreamProcessorService.getTargetStreamInjector()).dependency(LogStreamServiceNames.SNAPSHOT_STORAGE_SERVICE, incidentStreamProcessorService.getSnapshotStorageInjector()).dependency(SystemServiceNames.ACTOR_SCHEDULER_SERVICE, incidentStreamProcessorService.getActorSchedulerInjector()).install();
    }

    public void start(ServiceStartContext serviceContext) {
        this.serviceContext = serviceContext;
        this.asyncContext = new DeferredCommandContext();
        ActorScheduler actorScheduler = (ActorScheduler)this.actorSchedulerInjector.getValue();
        this.actorRef = actorScheduler.schedule((Actor)this);
    }

    public void stop(ServiceStopContext ctx) {
        ctx.run(() -> this.actorRef.close());
    }

    public WorkflowQueueManager get() {
        return this;
    }

    public Injector<ServerTransport> getClientApiTransportInjector() {
        return this.clientApiTransportInjector;
    }

    public ServiceGroupReference<LogStream> getLogStreamsGroupReference() {
        return this.logStreamsGroupReference;
    }

    public Injector<ActorScheduler> getActorSchedulerInjector() {
        return this.actorSchedulerInjector;
    }

    public void addStream(LogStream logStream, ServiceName<LogStream> logStreamServiceName) {
        this.asyncContext.runAsync(r -> this.startWorkflowQueue(logStream));
    }

    public int getPriority(long now) {
        return 1;
    }

    public int doWork() throws Exception {
        return this.asyncContext.doWork();
    }

    public String name() {
        return NAME;
    }
}

