/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.workflow.graph.model;

import io.zeebe.broker.workflow.graph.model.ExecutableEndEvent;
import io.zeebe.broker.workflow.graph.model.ExecutableFlowElement;
import io.zeebe.broker.workflow.graph.model.ExecutableSequenceFlow;
import io.zeebe.broker.workflow.graph.model.ExecutableServiceTask;
import io.zeebe.broker.workflow.graph.model.ExecutableStartEvent;
import io.zeebe.broker.workflow.graph.model.ExecutableWorkflow;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.agrona.LangUtil;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.EndEvent;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.bpmn.instance.ServiceTask;
import org.camunda.bpm.model.bpmn.instance.StartEvent;

public class BpmnFactory {
    private static final Map<Class<? extends BaseElement>, Class<? extends ExecutableFlowElement>> TYPE_MAPPING = new HashMap<Class<? extends BaseElement>, Class<? extends ExecutableFlowElement>>();

    public static ExecutableFlowElement createElement(BaseElement element) {
        Class modelElementType = element.getElementType().getInstanceType();
        Class<? extends ExecutableFlowElement> type = TYPE_MAPPING.get(modelElementType);
        if (type != null) {
            try {
                return type.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                LangUtil.rethrowUnchecked((Throwable)e);
            }
        }
        throw new RuntimeException("No type mapping for type " + modelElementType);
    }

    public static Collection<Class<? extends BaseElement>> getSupportedTypes() {
        return TYPE_MAPPING.keySet();
    }

    static {
        TYPE_MAPPING.put(StartEvent.class, ExecutableStartEvent.class);
        TYPE_MAPPING.put(EndEvent.class, ExecutableEndEvent.class);
        TYPE_MAPPING.put(ServiceTask.class, ExecutableServiceTask.class);
        TYPE_MAPPING.put(SequenceFlow.class, ExecutableSequenceFlow.class);
        TYPE_MAPPING.put(Process.class, ExecutableWorkflow.class);
    }
}

