/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.workflow.graph.transformer;

import io.zeebe.broker.workflow.graph.transformer.ZeebeExtensions;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class IOMappingBuilder {
    public static final String MAPPING_ATTRIBUTE_SOURCE = "source";
    public static final String MAPPING_ATTRIBUTE_TARGET = "target";
    private final ZeebeExtensions.ZeebeModelInstance zeebeModelInstance;
    private final ModelElementInstance ioMapping;

    public IOMappingBuilder(ZeebeExtensions.ZeebeModelInstance zeebeModelInstance, ModelElementInstance ioMapping) {
        this.ioMapping = ioMapping;
        this.zeebeModelInstance = zeebeModelInstance;
    }

    public IOMappingBuilder input(String source, String target) {
        this.addMappingElement("input", source, target);
        return this;
    }

    public IOMappingBuilder output(String source, String target) {
        this.addMappingElement("output", source, target);
        return this;
    }

    public ZeebeExtensions.ZeebeModelInstance done() {
        return this.zeebeModelInstance;
    }

    private void addMappingElement(String mappingElement, String source, String target) {
        DomElement inputMapping = this.zeebeModelInstance.getDocument().createElement("http://camunda.org/schema/zeebe/1.0", mappingElement);
        inputMapping.setAttribute(MAPPING_ATTRIBUTE_SOURCE, source);
        inputMapping.setAttribute(MAPPING_ATTRIBUTE_TARGET, target);
        this.ioMapping.getDomElement().appendChild(inputMapping);
    }
}

