/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.workflow.graph.transformer;

import io.zeebe.broker.workflow.graph.model.BpmnFactory;
import io.zeebe.broker.workflow.graph.model.ExecutableFlowElement;
import io.zeebe.broker.workflow.graph.model.ExecutableScope;
import io.zeebe.broker.workflow.graph.model.ExecutableStartEvent;
import io.zeebe.broker.workflow.graph.model.ExecutableWorkflow;
import io.zeebe.broker.workflow.graph.transformer.BpmnElementTransformer;
import io.zeebe.broker.workflow.graph.transformer.Transformers;
import io.zeebe.util.EnsureUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.FlowElement;
import org.camunda.bpm.model.bpmn.instance.Process;

public class ProcessTransformer
implements BpmnElementTransformer<Process, ExecutableWorkflow> {
    @Override
    public Class<Process> getType() {
        return Process.class;
    }

    @Override
    public void transform(Process modelElement, ExecutableWorkflow executableWorkflow, ExecutableScope scope) {
        executableWorkflow.setId(modelElement.getId());
        executableWorkflow.setName(modelElement.getName());
        Collection flowElements = modelElement.getChildElementsByType(FlowElement.class);
        this.transformChildElements(executableWorkflow, scope, flowElements);
        this.setStartEvent(executableWorkflow);
    }

    private void transformChildElements(ExecutableWorkflow executableWorkflow, ExecutableScope scope, Collection<FlowElement> flowElements) {
        HashMap<FlowElement, ExecutableFlowElement> executableFlowElements = new HashMap<FlowElement, ExecutableFlowElement>();
        for (FlowElement flowElement : flowElements) {
            ExecutableFlowElement executableElement = BpmnFactory.createElement((BaseElement)flowElement);
            executableElement.setId(flowElement.getId());
            executableElement.setFlowScope(scope);
            executableElement.setWorkflow(executableWorkflow);
            executableWorkflow.getFlowElementMap().put(executableElement.getId(), executableElement);
            executableFlowElements.put(flowElement, executableElement);
        }
        scope.setFlowElements(executableFlowElements.values().toArray(new ExecutableFlowElement[executableFlowElements.size()]));
        for (Map.Entry entry : executableFlowElements.entrySet()) {
            Transformers.apply((BaseElement)entry.getKey(), (ExecutableFlowElement)entry.getValue(), executableWorkflow);
        }
    }

    private void setStartEvent(ExecutableWorkflow executableWorkflow) {
        for (ExecutableFlowElement flowElement : executableWorkflow.getFlowElements()) {
            if (!(flowElement instanceof ExecutableStartEvent)) continue;
            ExecutableStartEvent startEvent = (ExecutableStartEvent)flowElement;
            if (executableWorkflow.getScopeStartEvent() == null) {
                executableWorkflow.setScopeStartEvent(startEvent);
                continue;
            }
            throw new RuntimeException("a workflow can only have one start event");
        }
        EnsureUtil.ensureNotNull((String)"start event", (Object)executableWorkflow.getScopeStartEvent());
    }
}

