/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.workflow.graph.transformer;

import io.zeebe.broker.workflow.graph.model.ExecutableScope;
import io.zeebe.broker.workflow.graph.model.ExecutableServiceTask;
import io.zeebe.broker.workflow.graph.model.metadata.IOMapping;
import io.zeebe.broker.workflow.graph.model.metadata.TaskMetadata;
import io.zeebe.broker.workflow.graph.transformer.BpmnElementTransformer;
import io.zeebe.broker.workflow.graph.transformer.metadata.IOMappingTransformer;
import io.zeebe.broker.workflow.graph.transformer.metadata.TaskMetadataTransformer;
import io.zeebe.util.EnsureUtil;
import org.camunda.bpm.model.bpmn.instance.ExtensionElements;
import org.camunda.bpm.model.bpmn.instance.ServiceTask;

public class ServiceTaskTransformer
implements BpmnElementTransformer<ServiceTask, ExecutableServiceTask> {
    @Override
    public Class<ServiceTask> getType() {
        return ServiceTask.class;
    }

    @Override
    public void transform(ServiceTask modelElement, ExecutableServiceTask bpmnElement, ExecutableScope scope) {
        ExtensionElements extensionElements = modelElement.getExtensionElements();
        EnsureUtil.ensureNotNull((String)"extension elements", (Object)extensionElements);
        TaskMetadata taskMetadata = TaskMetadataTransformer.transform(extensionElements);
        EnsureUtil.ensureNotNull((String)"task metadata", (Object)taskMetadata);
        bpmnElement.setTaskMetadata(taskMetadata);
        IOMapping ioMapping = IOMappingTransformer.transform(extensionElements);
        EnsureUtil.ensureNotNull((String)"task io mapping", (Object)ioMapping);
        bpmnElement.setIoMapping(ioMapping);
    }
}

