/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.workflow.graph.transformer;

import io.zeebe.broker.workflow.graph.model.BpmnFactory;
import io.zeebe.broker.workflow.graph.model.ExecutableFlowElement;
import io.zeebe.broker.workflow.graph.model.ExecutableScope;
import io.zeebe.broker.workflow.graph.transformer.BpmnElementTransformer;
import io.zeebe.broker.workflow.graph.transformer.FlowElementTransformer;
import io.zeebe.broker.workflow.graph.transformer.FlowNodeTransformer;
import io.zeebe.broker.workflow.graph.transformer.ProcessTransformer;
import io.zeebe.broker.workflow.graph.transformer.SequenceFlowTransformer;
import io.zeebe.broker.workflow.graph.transformer.ServiceTaskTransformer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.xml.Model;
import org.camunda.bpm.model.xml.type.ModelElementType;

public class Transformers {
    private static final Map<Class<? extends BaseElement>, BpmnElementTransformer<?, ?>> TRANSFORMERS = new HashMap();
    private static final Map<Class<? extends BaseElement>, List<BpmnElementTransformer<?, ?>>> TRANSFORMERS_BY_TYPE = new HashMap();

    private static void initTransformers(Class<? extends BaseElement> instanceType) {
        ArrayList transformers = new ArrayList();
        Model bpmnModel = Bpmn.INSTANCE.getBpmnModel();
        ModelElementType modelType = bpmnModel.getType(instanceType);
        do {
            BpmnElementTransformer<?, ?> transformer;
            if ((transformer = TRANSFORMERS.get(modelType.getInstanceType())) == null) continue;
            transformers.add(0, transformer);
        } while ((modelType = modelType.getBaseType()) != null);
        TRANSFORMERS_BY_TYPE.put(instanceType, transformers);
    }

    private static void registerTransformer(BpmnElementTransformer<?, ?> baseElementTransformer) {
        TRANSFORMERS.put(baseElementTransformer.getType(), baseElementTransformer);
    }

    public static void apply(BaseElement modelElement, ExecutableFlowElement executableElement, ExecutableScope scope) {
        List<BpmnElementTransformer<?, ?>> transformers = TRANSFORMERS_BY_TYPE.get(modelElement.getElementType().getInstanceType());
        if (transformers != null) {
            for (BpmnElementTransformer<?, ?> bpmnElementTransformer : transformers) {
                bpmnElementTransformer.transform(modelElement, executableElement, scope);
            }
        }
    }

    static {
        Transformers.registerTransformer(new FlowElementTransformer());
        Transformers.registerTransformer(new FlowNodeTransformer());
        Transformers.registerTransformer(new ProcessTransformer());
        Transformers.registerTransformer(new SequenceFlowTransformer());
        Transformers.registerTransformer(new ServiceTaskTransformer());
        BpmnFactory.getSupportedTypes().forEach(Transformers::initTransformers);
    }
}

