/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.workflow.graph.transformer;

import io.zeebe.broker.workflow.graph.transformer.IOMappingBuilder;
import java.util.Collection;
import java.util.Map;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.Definitions;
import org.camunda.bpm.model.bpmn.instance.ExtensionElements;
import org.camunda.bpm.model.xml.Model;
import org.camunda.bpm.model.xml.instance.DomDocument;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.type.ModelElementType;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResults;

public class ZeebeExtensions {
    public static final String ZEEBE_NAMESPACE = "http://camunda.org/schema/zeebe/1.0";
    public static final String IO_MAPPING_ELEMENT = "ioMapping";
    public static final String INPUT_MAPPING_ELEMENT = "input";
    public static final String OUTPUT_MAPPING_ELEMENT = "output";
    public static final String MAPPING_ATTRIBUTE_SOURCE = "source";
    public static final String MAPPING_ATTRIBUTE_TARGET = "target";
    public static final String TASK_DEFINITION_ELEMENT = "taskDefinition";
    public static final String TASK_HEADERS_ELEMENT = "taskHeaders";
    public static final String TASK_HEADER_ELEMENT = "header";
    public static final String TASK_TYPE_ATTRIBUTE = "type";
    public static final String TASK_RETRIES_ATTRIBUTE = "retries";
    public static final String TASK_HEADER_KEY_ATTRIBUTE = "key";
    public static final String TASK_HEADER_VALUE_ATTRIBUTE = "value";

    public static ZeebeModelInstance wrap(BpmnModelInstance modelInstance) {
        return new ZeebeModelInstance(modelInstance);
    }

    public static class ZeebeModelInstance
    implements BpmnModelInstance {
        protected BpmnModelInstance wrappedInstance;

        public ZeebeModelInstance(BpmnModelInstance wrappedInstance) {
            this.wrappedInstance = wrappedInstance;
        }

        public DomDocument getDocument() {
            return this.wrappedInstance.getDocument();
        }

        public ModelElementInstance getDocumentElement() {
            return this.wrappedInstance.getDocumentElement();
        }

        public void setDocumentElement(ModelElementInstance documentElement) {
            this.wrappedInstance.setDocumentElement(documentElement);
        }

        public <T extends ModelElementInstance> T newInstance(Class<T> type) {
            return (T)this.wrappedInstance.newInstance(type);
        }

        public <T extends ModelElementInstance> T newInstance(ModelElementType type) {
            return (T)this.wrappedInstance.newInstance(type);
        }

        public Model getModel() {
            return this.wrappedInstance.getModel();
        }

        public <T extends ModelElementInstance> T getModelElementById(String id) {
            return (T)this.wrappedInstance.getModelElementById(id);
        }

        public Collection<ModelElementInstance> getModelElementsByType(ModelElementType referencingType) {
            return this.wrappedInstance.getModelElementsByType(referencingType);
        }

        public <T extends ModelElementInstance> Collection<T> getModelElementsByType(Class<T> referencingClass) {
            return this.wrappedInstance.getModelElementsByType(referencingClass);
        }

        public ValidationResults validate(Collection<ModelElementValidator<?>> validators) {
            return this.wrappedInstance.validate(validators);
        }

        public BpmnModelInstance clone() {
            return this.wrappedInstance.clone();
        }

        public Definitions getDefinitions() {
            return this.wrappedInstance.getDefinitions();
        }

        public void setDefinitions(Definitions arg0) {
            this.wrappedInstance.setDefinitions(arg0);
        }

        public ZeebeModelInstance taskDefinition(String activityId, String taskType, int retries) {
            ExtensionElements extensionElements = this.getExtensionElements(activityId);
            ModelElementInstance taskDefinition = extensionElements.addExtensionElement(ZeebeExtensions.ZEEBE_NAMESPACE, ZeebeExtensions.TASK_DEFINITION_ELEMENT);
            taskDefinition.setAttributeValue(ZeebeExtensions.TASK_TYPE_ATTRIBUTE, taskType);
            taskDefinition.setAttributeValue(ZeebeExtensions.TASK_RETRIES_ATTRIBUTE, String.valueOf(retries));
            return this;
        }

        public ZeebeModelInstance taskHeaders(String activityId, Map<String, String> headers) {
            ExtensionElements extensionElements = this.getExtensionElements(activityId);
            ModelElementInstance taskHeaders = extensionElements.addExtensionElement(ZeebeExtensions.ZEEBE_NAMESPACE, ZeebeExtensions.TASK_HEADERS_ELEMENT);
            headers.forEach((k, v) -> {
                DomElement taskHeader = this.wrappedInstance.getDocument().createElement(ZeebeExtensions.ZEEBE_NAMESPACE, ZeebeExtensions.TASK_HEADER_ELEMENT);
                taskHeader.setAttribute(ZeebeExtensions.TASK_HEADER_KEY_ATTRIBUTE, k);
                taskHeader.setAttribute(ZeebeExtensions.TASK_HEADER_VALUE_ATTRIBUTE, v);
                taskHeaders.getDomElement().appendChild(taskHeader);
            });
            return this;
        }

        public ZeebeModelInstance ioMapping(String activityId, Map<String, String> inputMappings, Map<String, String> outputMappings) {
            ExtensionElements extensionElements = this.getExtensionElements(activityId);
            ModelElementInstance ioMapping = extensionElements.addExtensionElement(ZeebeExtensions.ZEEBE_NAMESPACE, ZeebeExtensions.IO_MAPPING_ELEMENT);
            if (inputMappings != null) {
                inputMappings.forEach((k, v) -> this.addMappingElement(ioMapping, ZeebeExtensions.INPUT_MAPPING_ELEMENT, (String)k, (String)v));
            }
            if (outputMappings != null) {
                outputMappings.forEach((k, v) -> this.addMappingElement(ioMapping, ZeebeExtensions.OUTPUT_MAPPING_ELEMENT, (String)k, (String)v));
            }
            return this;
        }

        public IOMappingBuilder ioMapping(String activityId) {
            ExtensionElements extensionElements = this.getExtensionElements(activityId);
            ModelElementInstance ioMapping = extensionElements.addExtensionElement(ZeebeExtensions.ZEEBE_NAMESPACE, ZeebeExtensions.IO_MAPPING_ELEMENT);
            return new IOMappingBuilder(this, ioMapping);
        }

        private void addMappingElement(ModelElementInstance ioMapping, String mappingElement, String source, String target) {
            DomElement mapping = this.wrappedInstance.getDocument().createElement(ZeebeExtensions.ZEEBE_NAMESPACE, mappingElement);
            mapping.setAttribute(ZeebeExtensions.MAPPING_ATTRIBUTE_SOURCE, source);
            mapping.setAttribute(ZeebeExtensions.MAPPING_ATTRIBUTE_TARGET, target);
            ioMapping.getDomElement().appendChild(mapping);
        }

        private ExtensionElements getExtensionElements(String activityId) {
            ModelElementInstance taskElement = this.wrappedInstance.getModelElementById(activityId);
            ExtensionElements extensionElements = (ExtensionElements)taskElement.getUniqueChildElementByType(ExtensionElements.class);
            if (extensionElements == null) {
                extensionElements = (ExtensionElements)this.wrappedInstance.newInstance(ExtensionElements.class);
                taskElement.addChildElement((ModelElementInstance)extensionElements);
            }
            return extensionElements;
        }
    }
}

