/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.workflow.graph.transformer.metadata;

import io.zeebe.broker.workflow.graph.model.metadata.IOMapping;
import io.zeebe.msgpack.jsonpath.JsonPathQueryCompiler;
import io.zeebe.msgpack.mapping.Mapping;
import java.util.List;
import org.agrona.Strings;
import org.camunda.bpm.model.bpmn.instance.ExtensionElements;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class IOMappingTransformer {
    private static final String DEFAULT_MAPPING = "$";

    public static IOMapping transform(ExtensionElements extensionElements) {
        IOMapping ioMapping = new IOMapping();
        ModelElementInstance ioMappingElement = extensionElements.getUniqueChildElementByNameNs("http://camunda.org/schema/zeebe/1.0", "ioMapping");
        List inputMappingElements = null;
        List outputMappingElements = null;
        if (ioMappingElement != null) {
            DomElement domElement = ioMappingElement.getDomElement();
            inputMappingElements = domElement.getChildElementsByNameNs("http://camunda.org/schema/zeebe/1.0", "input");
            outputMappingElements = domElement.getChildElementsByNameNs("http://camunda.org/schema/zeebe/1.0", "output");
        }
        ioMapping.setInputMappings(IOMappingTransformer.createMappings(inputMappingElements));
        ioMapping.setOutputMappings(IOMappingTransformer.createMappings(outputMappingElements));
        return ioMapping;
    }

    private static Mapping[] createMappings(List<DomElement> mappingElements) {
        Mapping[] mappings;
        if (mappingElements == null || mappingElements.isEmpty()) {
            mappings = new Mapping[]{};
        } else if (mappingElements.size() == 1) {
            mappings = IOMappingTransformer.createNonRootMapping(mappingElements.get(0));
        } else {
            mappings = new Mapping[mappingElements.size()];
            for (int i = 0; i < mappingElements.size(); ++i) {
                DomElement mappingElement = mappingElements.get(i);
                mappings[i] = IOMappingTransformer.createMapping(mappingElement);
            }
        }
        return mappings;
    }

    private static Mapping[] createNonRootMapping(DomElement mappingElement) {
        String sourceMapping = IOMappingTransformer.getMappingQuery(mappingElement, "source");
        String targetMapping = IOMappingTransformer.getMappingQuery(mappingElement, "target");
        Mapping[] mappings = sourceMapping.equals(DEFAULT_MAPPING) && targetMapping.equals(DEFAULT_MAPPING) ? new Mapping[]{} : new Mapping[]{new Mapping(new JsonPathQueryCompiler().compile(sourceMapping), targetMapping)};
        return mappings;
    }

    private static Mapping createMapping(DomElement mappingElement) {
        String sourceMapping = IOMappingTransformer.getMappingQuery(mappingElement, "source");
        String targetMapping = IOMappingTransformer.getMappingQuery(mappingElement, "target");
        return new Mapping(new JsonPathQueryCompiler().compile(sourceMapping), targetMapping);
    }

    private static String getMappingQuery(DomElement mappingElement, String attributeName) {
        String mapping;
        String mappingValue = DEFAULT_MAPPING;
        if (mappingElement != null && !Strings.isEmpty((String)(mapping = mappingElement.getAttribute(attributeName)))) {
            mappingValue = mapping;
        }
        return mappingValue;
    }
}

