/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.workflow.graph.transformer.metadata;

import io.zeebe.broker.workflow.graph.model.metadata.TaskMetadata;
import io.zeebe.msgpack.spec.MsgPackWriter;
import io.zeebe.util.EnsureUtil;
import io.zeebe.util.buffer.BufferUtil;
import java.util.List;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.camunda.bpm.model.bpmn.instance.ExtensionElements;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class TaskMetadataTransformer {
    private static final int DEFAULT_TASK_RETRIES = 3;
    public static final int INITIAL_SIZE_KEY_VALUE_PAIR = 256;

    public static TaskMetadata transform(ExtensionElements extensionElements) {
        TaskMetadata metadata = new TaskMetadata();
        ModelElementInstance taskDefinition = TaskMetadataTransformer.getTaskDefinition(extensionElements);
        String type = TaskMetadataTransformer.getTaskType(taskDefinition);
        metadata.setTaskType(BufferUtil.wrapString((String)type));
        int retries = TaskMetadataTransformer.getTaskRetries(taskDefinition);
        metadata.setRetries(retries);
        MutableDirectBuffer taskHeaders = TaskMetadataTransformer.getTaskHeaders(extensionElements);
        metadata.setHeaders((DirectBuffer)taskHeaders);
        return metadata;
    }

    private static ModelElementInstance getTaskDefinition(ExtensionElements extensionElements) {
        ModelElementInstance taskDefinition = extensionElements.getUniqueChildElementByNameNs("http://camunda.org/schema/zeebe/1.0", "taskDefinition");
        EnsureUtil.ensureNotNull((String)"task definition", (Object)taskDefinition);
        return taskDefinition;
    }

    private static String getTaskType(ModelElementInstance taskDefinition) {
        String type = taskDefinition.getAttributeValue("type");
        EnsureUtil.ensureNotNull((String)"task type", (Object)type);
        return type;
    }

    private static int getTaskRetries(ModelElementInstance taskDefinition) {
        int retries = 3;
        String configuredRetries = taskDefinition.getAttributeValue("retries");
        if (configuredRetries != null && !configuredRetries.isEmpty()) {
            try {
                retries = Integer.parseInt(configuredRetries);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Failed to parse task retries. Expected number but found: " + configuredRetries);
            }
        }
        return retries;
    }

    private static MutableDirectBuffer getTaskHeaders(ExtensionElements extensionElements) {
        UnsafeBuffer buffer = new UnsafeBuffer(0L, 0);
        ModelElementInstance taskHeadersElement = extensionElements.getUniqueChildElementByNameNs("http://camunda.org/schema/zeebe/1.0", "taskHeaders");
        if (taskHeadersElement != null) {
            List headerElements = taskHeadersElement.getDomElement().getChildElementsByNameNs("http://camunda.org/schema/zeebe/1.0", "header");
            MsgPackWriter msgPackWriter = new MsgPackWriter();
            ExpandableArrayBuffer expandableBuffer = new ExpandableArrayBuffer(256 * headerElements.size());
            msgPackWriter.wrap((MutableDirectBuffer)expandableBuffer, 0);
            msgPackWriter.writeMapHeader(headerElements.size());
            for (int i = 0; i < headerElements.size(); ++i) {
                DomElement header = (DomElement)headerElements.get(i);
                String key = header.getAttribute("key");
                msgPackWriter.writeString(BufferUtil.wrapString((String)key));
                String value = header.getAttribute("value");
                msgPackWriter.writeString(BufferUtil.wrapString((String)value));
            }
            buffer.wrap(expandableBuffer.byteArray(), 0, msgPackWriter.getOffset());
        }
        return buffer;
    }
}

