/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.workflow.graph.transformer.validator;

import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class BpmnProcessIdRule
implements ModelElementValidator<Process> {
    public Class<Process> getElementType() {
        return Process.class;
    }

    public void validate(Process process, ValidationResultCollector validationResultCollector) {
        String bpmnProcessId = process.getId();
        if (bpmnProcessId == null || bpmnProcessId.isEmpty()) {
            validationResultCollector.addError(10, "BPMN process id is required.");
        } else if (bpmnProcessId.length() > 255) {
            validationResultCollector.addError(11, String.format("BPMN process id must not be longer than %d.", 255));
        }
    }
}

