/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.workflow.graph.transformer.validator;

import java.util.Collection;
import org.camunda.bpm.model.bpmn.instance.Definitions;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class ExecutableProcessRule
implements ModelElementValidator<Definitions> {
    public Class<Definitions> getElementType() {
        return Definitions.class;
    }

    public void validate(Definitions definitionsElement, ValidationResultCollector resultCollector) {
        Collection processes = definitionsElement.getChildElementsByType(Process.class);
        int executableProcesses = 0;
        for (Process process : processes) {
            if (!process.isExecutable()) continue;
            ++executableProcesses;
        }
        if (executableProcesses == 0) {
            resultCollector.addError(1, "BPMN model must contain at least one executable process.");
        } else if (executableProcesses > 1) {
            resultCollector.addError(2, "BPMN model must not contain more than one executable process.");
        }
    }
}

