/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.workflow.graph.transformer.validator;

import io.zeebe.msgpack.jsonpath.JsonPathQuery;
import io.zeebe.msgpack.jsonpath.JsonPathQueryCompiler;
import java.util.List;
import java.util.regex.Pattern;
import org.agrona.Strings;
import org.camunda.bpm.model.bpmn.instance.ExtensionElements;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class IOMappingRule
implements ModelElementValidator<ExtensionElements> {
    public static final String ERROR_MSG_PROHIBITED_EXPRESSION = "Mapping failed! JSON Path contains prohibited expression (for example $.* or $.(foo|bar)).";
    public static final String ERROR_MSG_INVALID_EXPRESSION = "Mapping failed JSON Path Query is not valid! Reason: %s";
    public static final String ERROR_MSG_REDUNDANT_MAPPING = "Mapping failed! If Root path is mapped other mapping (makes no sense) is disallowed.";
    private static final String PROHIBITED_EXPRESSIONS_REGEX = "(\\.\\*)|(\\[.*,.*\\])";
    private static final Pattern PROHIBITED_EXPRESSIONS = Pattern.compile("(\\.\\*)|(\\[.*,.*\\])");

    public Class<ExtensionElements> getElementType() {
        return ExtensionElements.class;
    }

    public void validate(ExtensionElements extensionElements, ValidationResultCollector validationResultCollector) {
        ModelElementInstance ioMappingElement = extensionElements.getUniqueChildElementByNameNs("http://camunda.org/schema/zeebe/1.0", "ioMapping");
        if (ioMappingElement != null) {
            DomElement domElement = ioMappingElement.getDomElement();
            List inputMappingElements = domElement.getChildElementsByNameNs("http://camunda.org/schema/zeebe/1.0", "input");
            List outputMappingElements = domElement.getChildElementsByNameNs("http://camunda.org/schema/zeebe/1.0", "output");
            IOMappingRule.validateMappings(validationResultCollector, inputMappingElements);
            IOMappingRule.validateMappings(validationResultCollector, outputMappingElements);
        }
    }

    private static void validateMappings(ValidationResultCollector validationResultCollector, List<DomElement> mappingElements) {
        if (mappingElements != null && !mappingElements.isEmpty()) {
            for (int i = 0; i < mappingElements.size(); ++i) {
                DomElement mapping = mappingElements.get(i);
                IOMappingRule.validateMappingExpression(validationResultCollector, mapping, "source");
                boolean isRootMapping = IOMappingRule.validateMappingExpression(validationResultCollector, mapping, "target");
                if (!isRootMapping || mappingElements.size() <= 1) continue;
                validationResultCollector.addError(62, ERROR_MSG_REDUNDANT_MAPPING);
            }
        }
    }

    private static boolean validateMappingExpression(ValidationResultCollector validationResultCollector, DomElement mappingElement, String attributeName) {
        String mapping;
        boolean isRootMapping = false;
        if (mappingElement != null && !Strings.isEmpty((String)(mapping = mappingElement.getAttribute(attributeName)))) {
            JsonPathQuery jsonPathQuery;
            if (PROHIBITED_EXPRESSIONS.matcher(mapping).find()) {
                validationResultCollector.addError(61, ERROR_MSG_PROHIBITED_EXPRESSION);
            }
            if (mapping.equals("$")) {
                isRootMapping = true;
            }
            if (!(jsonPathQuery = new JsonPathQueryCompiler().compile(mapping)).isValid()) {
                validationResultCollector.addError(60, String.format(ERROR_MSG_INVALID_EXPRESSION, jsonPathQuery.getErrorReason()));
            }
        }
        return isRootMapping;
    }
}

