/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.workflow.graph.transformer.validator;

import java.util.Collection;
import org.camunda.bpm.model.bpmn.instance.EndEvent;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class OutgoingSequenceFlowRule
implements ModelElementValidator<FlowNode> {
    public Class<FlowNode> getElementType() {
        return FlowNode.class;
    }

    public void validate(FlowNode flowNode, ValidationResultCollector validationResultCollector) {
        Collection outgoingSequenceFlows = flowNode.getOutgoing();
        if (flowNode instanceof EndEvent) {
            if (!outgoingSequenceFlows.isEmpty()) {
                validationResultCollector.addError(31, "An end event must not have an outgoing sequence flow.");
            }
        } else if (outgoingSequenceFlows.size() > 1) {
            validationResultCollector.addError(30, "The flow element must not have more than one outgoing sequence flow.");
        }
    }
}

