/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.workflow.graph.transformer.validator;

import java.util.Collection;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.bpmn.instance.StartEvent;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class ProcessStartEventRule
implements ModelElementValidator<Process> {
    public Class<Process> getElementType() {
        return Process.class;
    }

    public void validate(Process process, ValidationResultCollector validationResultCollector) {
        Collection startEvents = process.getChildElementsByType(StartEvent.class);
        int noneStartEventCount = 0;
        for (StartEvent startEvent : startEvents) {
            Collection eventDefinitions = startEvent.getEventDefinitions();
            if (eventDefinitions.isEmpty()) {
                ++noneStartEventCount;
                continue;
            }
            String errorMessage = String.format("Ignore start event with id '%s'. Event type is not supported.", startEvent.getId());
            validationResultCollector.addWarning(22, errorMessage);
        }
        if (noneStartEventCount == 0) {
            validationResultCollector.addError(20, "The process must contain at least one none start event.");
        } else if (noneStartEventCount > 1) {
            validationResultCollector.addError(21, "The process must not contain more than one none start event.");
        }
    }
}

