/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.workflow.graph.transformer.validator;

import java.util.List;
import org.camunda.bpm.model.bpmn.instance.ExtensionElements;
import org.camunda.bpm.model.bpmn.instance.ServiceTask;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class ServiceTaskRule
implements ModelElementValidator<ServiceTask> {
    public Class<ServiceTask> getElementType() {
        return ServiceTask.class;
    }

    public void validate(ServiceTask serviceTask, ValidationResultCollector validationResultCollector) {
        ExtensionElements extensionElements = serviceTask.getExtensionElements();
        ModelElementInstance taskDefinition = null;
        ModelElementInstance taskHeaders = null;
        if (extensionElements != null) {
            taskDefinition = extensionElements.getUniqueChildElementByNameNs("http://camunda.org/schema/zeebe/1.0", "taskDefinition");
            taskHeaders = extensionElements.getUniqueChildElementByNameNs("http://camunda.org/schema/zeebe/1.0", "taskHeaders");
        }
        if (taskDefinition == null) {
            validationResultCollector.addError(50, String.format("A service task must contain a '%s' extension element.", "taskDefinition"));
        } else {
            this.validateTaskDefinition(validationResultCollector, taskDefinition);
        }
        if (taskHeaders != null) {
            this.validateTaskHeaders(validationResultCollector, taskHeaders);
        }
    }

    private void validateTaskDefinition(ValidationResultCollector validationResultCollector, ModelElementInstance taskDefinition) {
        String taskRetries;
        String taskType = taskDefinition.getAttributeValue("type");
        if (taskType == null || taskType.isEmpty()) {
            validationResultCollector.addError(51, String.format("A task definition must contain a '%s' attribute which specifies the type of the task.", "type"));
        }
        if ((taskRetries = taskDefinition.getAttributeValue("retries")) != null && !taskRetries.isEmpty()) {
            try {
                Integer.parseInt(taskRetries);
            }
            catch (NumberFormatException e) {
                validationResultCollector.addError(52, String.format("Invalid task retries in '%s' attribute. Expect number but found '%s'.", "retries", taskRetries));
            }
        }
    }

    private void validateTaskHeaders(ValidationResultCollector validationResultCollector, ModelElementInstance taskHeaders) {
        List taskHeaderElements = taskHeaders.getDomElement().getChildElementsByNameNs("http://camunda.org/schema/zeebe/1.0", "header");
        taskHeaderElements.forEach(element -> {
            String key = element.getAttribute("key");
            String value = element.getAttribute("value");
            if (key == null || key.isEmpty()) {
                validationResultCollector.addError(53, String.format("A task header must contain a '%s' attribute.", "key"));
            }
            if (value == null || value.isEmpty()) {
                validationResultCollector.addError(54, String.format("A task header must contain a '%s' attribute.", "value"));
            }
        });
    }
}

