/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.workflow.map;

import io.zeebe.logstreams.snapshot.ZbMapSnapshotSupport;
import io.zeebe.map.Long2BytesZbMap;
import io.zeebe.map.ZbMap;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class ActivityInstanceMap
implements AutoCloseable {
    private static final int SIZE_OF_ACTIVITY_ID = 510;
    private static final int INDEX_VALUE_SIZE = 522;
    private static final int TASK_KEY_OFFSET = 0;
    private static final int ACTIVITY_ID_LENGTH_OFFSET = 8;
    private static final int ACTIVITY_ID_OFFSET = 12;
    private static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final byte[] rawBuffer = new byte[522];
    private final UnsafeBuffer buffer = new UnsafeBuffer(this.rawBuffer);
    private final UnsafeBuffer activityIdBuffer = new UnsafeBuffer(new byte[510]);
    private final Long2BytesZbMap map = new Long2BytesZbMap(522);
    private final ZbMapSnapshotSupport<Long2BytesZbMap> snapshotSupport = new ZbMapSnapshotSupport((ZbMap)this.map);
    private long key;
    private boolean isRead = false;

    public ZbMapSnapshotSupport<Long2BytesZbMap> getSnapshotSupport() {
        return this.snapshotSupport;
    }

    public void reset() {
        this.isRead = false;
    }

    public void remove(long activityInstanceKey) {
        this.map.remove(activityInstanceKey, this.rawBuffer);
    }

    public ActivityInstanceMap wrapActivityInstanceKey(long key) {
        this.isRead = this.map.get(key, this.rawBuffer);
        this.key = key;
        return this;
    }

    public long getTaskKey() {
        return this.isRead ? this.buffer.getLong(0, BYTE_ORDER) : -1L;
    }

    public DirectBuffer getActivityId() {
        if (this.isRead) {
            int length = this.buffer.getInt(8, BYTE_ORDER);
            this.activityIdBuffer.wrap((DirectBuffer)this.buffer, 12, length);
        } else {
            this.activityIdBuffer.wrap(0L, 0);
        }
        return this.activityIdBuffer;
    }

    public ActivityInstanceMap newActivityInstance(long activityInstanceKey) {
        this.key = activityInstanceKey;
        this.isRead = true;
        return this;
    }

    public void write() {
        this.ensureRead();
        this.map.put(this.key, this.buffer.byteArray());
    }

    public ActivityInstanceMap setActivityId(DirectBuffer activityId) {
        this.ensureRead();
        this.buffer.putInt(8, activityId.capacity(), BYTE_ORDER);
        this.buffer.putBytes(12, activityId, 0, activityId.capacity());
        return this;
    }

    public ActivityInstanceMap setTaskKey(long taskKey) {
        this.ensureRead();
        this.buffer.putLong(0, taskKey, BYTE_ORDER);
        return this;
    }

    private void ensureRead() {
        if (!this.isRead) {
            throw new IllegalStateException("must call wrap() before");
        }
    }

    @Override
    public void close() {
        this.map.close();
    }
}

