/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.workflow.map;

import io.zeebe.broker.workflow.data.WorkflowInstanceEvent;
import io.zeebe.logstreams.log.LogStreamReader;
import io.zeebe.logstreams.log.LoggedEvent;
import io.zeebe.logstreams.snapshot.ZbMapSnapshotSupport;
import io.zeebe.map.Long2LongZbMap;
import io.zeebe.map.ZbMap;
import io.zeebe.util.buffer.BufferReader;
import io.zeebe.util.cache.ExpandableBufferCache;
import org.agrona.DirectBuffer;

public class PayloadCache
implements AutoCloseable {
    private final WorkflowInstanceEvent workflowInstanceEvent = new WorkflowInstanceEvent();
    private final Long2LongZbMap map = new Long2LongZbMap();
    private final ZbMapSnapshotSupport<Long2LongZbMap> snapshotSupport = new ZbMapSnapshotSupport((ZbMap)this.map);
    private final ExpandableBufferCache cache;
    private final LogStreamReader logStreamReader;

    public PayloadCache(int cacheSize, LogStreamReader logStreamReader) {
        this.logStreamReader = logStreamReader;
        this.cache = new ExpandableBufferCache(cacheSize, 1024, this::lookupPayload);
    }

    private DirectBuffer lookupPayload(long position) {
        DirectBuffer payload = null;
        boolean found = this.logStreamReader.seek(position);
        if (found && this.logStreamReader.hasNext()) {
            LoggedEvent event = (LoggedEvent)this.logStreamReader.next();
            this.workflowInstanceEvent.reset();
            event.readValue((BufferReader)this.workflowInstanceEvent);
            payload = this.workflowInstanceEvent.getPayload();
        }
        return payload;
    }

    public DirectBuffer getPayload(long workflowInstanceKey) {
        DirectBuffer payload = null;
        long position = this.map.get(workflowInstanceKey, -1L);
        if (position > 0L) {
            payload = this.cache.get(position);
        }
        return payload == null ? WorkflowInstanceEvent.NO_PAYLOAD : payload;
    }

    public void addPayload(long workflowInstanceKey, long payloadEventPosition, DirectBuffer payload) {
        this.map.put(workflowInstanceKey, payloadEventPosition);
        this.cache.put(payloadEventPosition, payload);
    }

    public void remove(long workflowInstanceKey) {
        this.map.remove(workflowInstanceKey, -1L);
    }

    public ZbMapSnapshotSupport<Long2LongZbMap> getSnapshotSupport() {
        return this.snapshotSupport;
    }

    @Override
    public void close() {
        this.map.close();
    }
}

