/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.workflow.map;

import io.zeebe.broker.workflow.data.WorkflowEvent;
import io.zeebe.broker.workflow.graph.model.ExecutableWorkflow;
import io.zeebe.broker.workflow.graph.transformer.BpmnTransformer;
import io.zeebe.logstreams.log.LogStreamReader;
import io.zeebe.logstreams.log.LoggedEvent;
import io.zeebe.logstreams.snapshot.ZbMapSnapshotSupport;
import io.zeebe.map.Bytes2LongZbMap;
import io.zeebe.map.ZbMap;
import io.zeebe.util.buffer.BufferReader;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.LongLruCache;
import org.agrona.concurrent.UnsafeBuffer;

public class WorkflowDeploymentCache
implements AutoCloseable {
    private static final int LATEST_VERSION = -1;
    private static final int SIZE_OF_PROCESS_ID = 510;
    private static final int SIZE_OF_COMPOSITE_KEY = 514;
    private final UnsafeBuffer buffer = new UnsafeBuffer(new byte[514]);
    private int bufferLength;
    private final WorkflowEvent workflowEvent = new WorkflowEvent();
    private final BpmnTransformer bpmnTransformer = new BpmnTransformer();
    private final Bytes2LongZbMap idVersionToKeyMap = new Bytes2LongZbMap(514);
    private final ZbMapSnapshotSupport<Bytes2LongZbMap> snapshotSupport = new ZbMapSnapshotSupport((ZbMap)this.idVersionToKeyMap);
    private final LongLruCache<ExecutableWorkflow> cache;
    private final LogStreamReader logStreamReader;

    public WorkflowDeploymentCache(int cacheSize, LogStreamReader logStreamReader) {
        this.logStreamReader = logStreamReader;
        this.cache = new LongLruCache(cacheSize, this::lookupWorkflow, workflow -> {});
    }

    public ZbMapSnapshotSupport<Bytes2LongZbMap> getSnapshotSupport() {
        return this.snapshotSupport;
    }

    private void wrap(DirectBuffer bpmnProcessId, int version) {
        bpmnProcessId.getBytes(0, (MutableDirectBuffer)this.buffer, 0, bpmnProcessId.capacity());
        this.buffer.putInt(bpmnProcessId.capacity(), version, ByteOrder.LITTLE_ENDIAN);
        this.bufferLength = bpmnProcessId.capacity() + 4;
    }

    public void addDeployedWorkflow(long workflowKey, DirectBuffer bpmnProcessId, int version) {
        this.wrap(bpmnProcessId, version);
        this.idVersionToKeyMap.put((DirectBuffer)this.buffer, 0, this.bufferLength, workflowKey);
        this.wrap(bpmnProcessId, -1);
        this.idVersionToKeyMap.put((DirectBuffer)this.buffer, 0, this.bufferLength, workflowKey);
    }

    public long getWorkflowKeyByIdAndLatestVersion(DirectBuffer bpmnProcessId) {
        return this.getWorkflowKeyByIdAndVersion(bpmnProcessId, -1);
    }

    public long getWorkflowKeyByIdAndVersion(DirectBuffer bpmnProcessId, int version) {
        this.wrap(bpmnProcessId, version);
        return this.idVersionToKeyMap.get((DirectBuffer)this.buffer, 0, this.bufferLength, -1L);
    }

    public ExecutableWorkflow getWorkflow(long workflowKey) {
        ExecutableWorkflow workflow = null;
        if (workflowKey >= 0L) {
            workflow = (ExecutableWorkflow)this.cache.lookup(workflowKey);
        }
        return workflow;
    }

    private ExecutableWorkflow lookupWorkflow(long position) {
        ExecutableWorkflow workflow = null;
        boolean found = this.logStreamReader.seek(position);
        if (found && this.logStreamReader.hasNext()) {
            LoggedEvent event = (LoggedEvent)this.logStreamReader.next();
            this.workflowEvent.reset();
            event.readValue((BufferReader)this.workflowEvent);
            workflow = this.bpmnTransformer.transform(this.workflowEvent.getBpmnXml()).get(0);
            workflow.setVersion(this.workflowEvent.getVersion());
        }
        return workflow;
    }

    @Override
    public void close() {
        this.idVersionToKeyMap.close();
    }
}

