/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.workflow.map;

import io.zeebe.logstreams.snapshot.ZbMapSnapshotSupport;
import io.zeebe.map.Long2BytesZbMap;
import io.zeebe.map.ZbMap;
import java.nio.ByteOrder;
import org.agrona.concurrent.UnsafeBuffer;

public class WorkflowInstanceIndex
implements AutoCloseable {
    private static final int INDEX_VALUE_SIZE = 20;
    private static final int POSITION_OFFSET = 0;
    private static final int TOKEN_COUNT_OFFSET = 8;
    private static final int ACTIVITY_INSTANCE_KEY_OFFSET = 12;
    private static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final byte[] rawBuffer = new byte[20];
    private final UnsafeBuffer buffer = new UnsafeBuffer(this.rawBuffer);
    private final Long2BytesZbMap map = new Long2BytesZbMap(20);
    private final ZbMapSnapshotSupport<Long2BytesZbMap> snapshotSupport = new ZbMapSnapshotSupport((ZbMap)this.map);
    private long key;
    private boolean isRead = false;

    public ZbMapSnapshotSupport<Long2BytesZbMap> getSnapshotSupport() {
        return this.snapshotSupport;
    }

    public void reset() {
        this.isRead = false;
    }

    public void remove(long workflowInstanceKey) {
        this.map.remove(workflowInstanceKey, this.rawBuffer);
    }

    public WorkflowInstanceIndex wrapWorkflowInstanceKey(long key) {
        this.isRead = this.map.get(key, this.rawBuffer);
        this.key = key;
        return this;
    }

    public long getPosition() {
        return this.isRead ? this.buffer.getLong(0, BYTE_ORDER) : -1L;
    }

    public int getTokenCount() {
        return this.isRead ? this.buffer.getInt(8, BYTE_ORDER) : -1;
    }

    public long getActivityInstanceKey() {
        return this.isRead ? this.buffer.getLong(12, BYTE_ORDER) : -1L;
    }

    public WorkflowInstanceIndex newWorkflowInstance(long workflowInstanceKey) {
        this.key = workflowInstanceKey;
        this.isRead = true;
        return this;
    }

    public void write() {
        this.ensureRead();
        this.map.put(this.key, this.buffer.byteArray());
    }

    public WorkflowInstanceIndex setPosition(long position) {
        this.ensureRead();
        this.buffer.putLong(0, position, BYTE_ORDER);
        return this;
    }

    public WorkflowInstanceIndex setActivityKey(long activityInstanceKey) {
        this.ensureRead();
        this.buffer.putLong(12, activityInstanceKey, BYTE_ORDER);
        return this;
    }

    public WorkflowInstanceIndex setActiveTokenCount(int activeTokenCount) {
        this.ensureRead();
        this.buffer.putInt(8, activeTokenCount, BYTE_ORDER);
        return this;
    }

    private void ensureRead() {
        if (!this.isRead) {
            throw new IllegalStateException("must call wrap() before");
        }
    }

    @Override
    public void close() {
        this.map.close();
    }
}

