/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.workflow.processor;

import io.zeebe.broker.logstreams.processor.MetadataFilter;
import io.zeebe.broker.transport.clientapi.CommandResponseWriter;
import io.zeebe.broker.workflow.data.DeploymentEvent;
import io.zeebe.broker.workflow.data.DeploymentState;
import io.zeebe.broker.workflow.data.WorkflowEvent;
import io.zeebe.broker.workflow.data.WorkflowState;
import io.zeebe.broker.workflow.graph.WorkflowValidationResultFormatter;
import io.zeebe.broker.workflow.graph.model.ExecutableWorkflow;
import io.zeebe.broker.workflow.graph.transformer.BpmnTransformer;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.log.LogStreamBatchWriter;
import io.zeebe.logstreams.log.LogStreamBatchWriterImpl;
import io.zeebe.logstreams.log.LogStreamWriter;
import io.zeebe.logstreams.log.LoggedEvent;
import io.zeebe.logstreams.processor.EventProcessor;
import io.zeebe.logstreams.processor.StreamProcessor;
import io.zeebe.logstreams.processor.StreamProcessorContext;
import io.zeebe.logstreams.snapshot.ZbMapSnapshotSupport;
import io.zeebe.logstreams.spi.SnapshotSupport;
import io.zeebe.map.Bytes2LongZbMap;
import io.zeebe.map.ZbMap;
import io.zeebe.protocol.clientapi.EventType;
import io.zeebe.protocol.impl.BrokerEventMetadata;
import io.zeebe.util.buffer.BufferReader;
import io.zeebe.util.buffer.BufferWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.agrona.DirectBuffer;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.xml.validation.ValidationResultFormatter;
import org.camunda.bpm.model.xml.validation.ValidationResults;

public class DeploymentStreamProcessor
implements StreamProcessor,
EventProcessor {
    protected final BrokerEventMetadata sourceEventMetadata = new BrokerEventMetadata();
    protected final BrokerEventMetadata targetEventMetadata = new BrokerEventMetadata();
    protected final DeploymentEvent deploymentEvent = new DeploymentEvent();
    protected final WorkflowEvent workflowEvent = new WorkflowEvent();
    protected final BpmnTransformer bpmnTransformer = new BpmnTransformer();
    protected final WorkflowValidationResultFormatter validationResultFormatter = new WorkflowValidationResultFormatter();
    protected final CommandResponseWriter responseWriter;
    protected final Bytes2LongZbMap map;
    protected final ZbMapSnapshotSupport<Bytes2LongZbMap> indexSnapshotSupport;
    protected final ArrayList<DeployedWorkflow> deployedWorkflows = new ArrayList();
    protected DirectBuffer logStreamTopicName;
    protected int logStreamPartitionId;
    protected LogStream targetStream;
    protected LogStreamBatchWriter logStreamBatchWriter;
    protected int streamProcessorId;
    protected long eventKey;
    protected long eventPosition;

    public DeploymentStreamProcessor(CommandResponseWriter responseWriter) {
        this.responseWriter = responseWriter;
        this.map = new Bytes2LongZbMap(510);
        this.indexSnapshotSupport = new ZbMapSnapshotSupport((ZbMap)this.map);
    }

    public SnapshotSupport getStateResource() {
        return this.indexSnapshotSupport;
    }

    public void onOpen(StreamProcessorContext context) {
        LogStream sourceStream = context.getSourceStream();
        this.logStreamTopicName = sourceStream.getTopicName();
        this.logStreamPartitionId = sourceStream.getPartitionId();
        this.streamProcessorId = context.getId();
        this.logStreamBatchWriter = new LogStreamBatchWriterImpl(context.getTargetStream());
        this.targetStream = context.getTargetStream();
    }

    public void onClose() {
        this.map.close();
    }

    public static MetadataFilter eventFilter() {
        return m -> m.getEventType() == EventType.DEPLOYMENT_EVENT;
    }

    public EventProcessor onEvent(LoggedEvent event) {
        this.sourceEventMetadata.reset();
        this.deploymentEvent.reset();
        this.eventKey = event.getKey();
        this.eventPosition = event.getPosition();
        event.readMetadata((BufferReader)this.sourceEventMetadata);
        event.readValue((BufferReader)this.deploymentEvent);
        DeploymentStreamProcessor eventProcessor = null;
        switch (this.deploymentEvent.getState()) {
            case CREATE_DEPLOYMENT: {
                eventProcessor = this;
                break;
            }
        }
        return eventProcessor;
    }

    public void afterEvent() {
        this.deployedWorkflows.clear();
    }

    public void processEvent() {
        try {
            BpmnModelInstance bpmnModelInstance = this.bpmnTransformer.readModelFromBuffer(this.deploymentEvent.getBpmnXml());
            ValidationResults validationResults = this.bpmnTransformer.validate(bpmnModelInstance);
            if (!validationResults.hasErrors()) {
                this.deploymentEvent.setState(DeploymentState.DEPLOYMENT_CREATED);
                this.collectDeployedWorkflows(bpmnModelInstance);
            }
            if (validationResults.getErrorCount() > 0 || validationResults.getWarinigCount() > 0) {
                String errorMessage = this.generateErrorMessage(validationResults);
                this.deploymentEvent.setErrorMessage(errorMessage);
            }
        }
        catch (Exception e) {
            String errorMessage = this.generateErrorMessage(e);
            this.deploymentEvent.setErrorMessage(errorMessage);
        }
        if (this.deployedWorkflows.isEmpty()) {
            this.deploymentEvent.setState(DeploymentState.DEPLOYMENT_REJECTED);
        }
    }

    protected void collectDeployedWorkflows(BpmnModelInstance bpmnModelInstance) {
        List<ExecutableWorkflow> workflows = this.bpmnTransformer.transform(bpmnModelInstance);
        ExecutableWorkflow workflow = workflows.get(0);
        DirectBuffer bpmnProcessId = workflow.getId();
        int latestVersion = (int)this.map.get(bpmnProcessId.byteArray(), 0L);
        int version = latestVersion + 1;
        ((io.zeebe.broker.workflow.data.DeployedWorkflow)((Object)this.deploymentEvent.deployedWorkflows().add())).setBpmnProcessId(bpmnProcessId).setVersion(version);
        this.deployedWorkflows.add(new DeployedWorkflow(bpmnProcessId, version));
    }

    protected String generateErrorMessage(ValidationResults validationResults) {
        StringWriter errorMessageWriter = new StringWriter();
        validationResults.write(errorMessageWriter, (ValidationResultFormatter)this.validationResultFormatter);
        return errorMessageWriter.toString();
    }

    protected String generateErrorMessage(Exception e) {
        StringWriter stacktraceWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stacktraceWriter));
        return String.format("Failed to deploy BPMN model: %s", stacktraceWriter);
    }

    public boolean executeSideEffects() {
        return this.responseWriter.topicName(this.logStreamTopicName).partitionId(this.logStreamPartitionId).position(this.eventPosition).key(this.eventKey).eventWriter((BufferWriter)this.deploymentEvent).tryWriteResponse(this.sourceEventMetadata.getRequestStreamId(), this.sourceEventMetadata.getRequestId());
    }

    public long writeEvent(LogStreamWriter writer) {
        this.logStreamBatchWriter.producerId(this.streamProcessorId).sourceEvent(this.logStreamTopicName, this.logStreamPartitionId, this.eventPosition);
        this.targetEventMetadata.reset();
        this.targetEventMetadata.protocolVersion(1).eventType(EventType.DEPLOYMENT_EVENT).raftTermId(this.targetStream.getTerm());
        this.logStreamBatchWriter.event().key(this.eventKey).metadataWriter((BufferWriter)this.targetEventMetadata).valueWriter((BufferWriter)this.deploymentEvent).done();
        this.targetEventMetadata.eventType(EventType.WORKFLOW_EVENT);
        for (int i = 0; i < this.deployedWorkflows.size(); ++i) {
            DeployedWorkflow deployedWorkflow = this.deployedWorkflows.get(i);
            this.workflowEvent.reset();
            this.workflowEvent.setState(WorkflowState.CREATED).setBpmnProcessId(deployedWorkflow.getBpmnProcessId()).setVersion(deployedWorkflow.getVersion()).setBpmnXml(this.deploymentEvent.getBpmnXml()).setDeploymentKey(this.eventKey);
            this.logStreamBatchWriter.event().positionAsKey().metadataWriter((BufferWriter)this.targetEventMetadata).valueWriter((BufferWriter)this.workflowEvent).done();
        }
        return this.logStreamBatchWriter.tryWrite();
    }

    public void updateState() {
        for (int i = 0; i < this.deployedWorkflows.size(); ++i) {
            DeployedWorkflow deployedWorkflow = this.deployedWorkflows.get(i);
            this.map.put(deployedWorkflow.getBpmnProcessId().byteArray(), (long)deployedWorkflow.getVersion());
        }
    }

    private static final class DeployedWorkflow {
        private final DirectBuffer bpmnProcessId;
        private final int version;

        DeployedWorkflow(DirectBuffer bpmnProcessId, int version) {
            this.bpmnProcessId = bpmnProcessId;
            this.version = version;
        }

        public DirectBuffer getBpmnProcessId() {
            return this.bpmnProcessId;
        }

        public int getVersion() {
            return this.version;
        }
    }
}

