/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.workflow.processor;

import io.zeebe.broker.logstreams.processor.MetadataFilter;
import io.zeebe.broker.task.data.TaskEvent;
import io.zeebe.broker.task.data.TaskHeaders;
import io.zeebe.broker.task.data.TaskState;
import io.zeebe.broker.transport.clientapi.CommandResponseWriter;
import io.zeebe.broker.util.PayloadUtil;
import io.zeebe.broker.workflow.data.WorkflowEvent;
import io.zeebe.broker.workflow.data.WorkflowInstanceEvent;
import io.zeebe.broker.workflow.data.WorkflowInstanceState;
import io.zeebe.broker.workflow.graph.model.BpmnAspect;
import io.zeebe.broker.workflow.graph.model.ExecutableEndEvent;
import io.zeebe.broker.workflow.graph.model.ExecutableFlowElement;
import io.zeebe.broker.workflow.graph.model.ExecutableFlowNode;
import io.zeebe.broker.workflow.graph.model.ExecutableSequenceFlow;
import io.zeebe.broker.workflow.graph.model.ExecutableServiceTask;
import io.zeebe.broker.workflow.graph.model.ExecutableStartEvent;
import io.zeebe.broker.workflow.graph.model.ExecutableWorkflow;
import io.zeebe.broker.workflow.graph.model.metadata.TaskMetadata;
import io.zeebe.broker.workflow.map.ActivityInstanceMap;
import io.zeebe.broker.workflow.map.PayloadCache;
import io.zeebe.broker.workflow.map.WorkflowDeploymentCache;
import io.zeebe.broker.workflow.map.WorkflowInstanceIndex;
import io.zeebe.logstreams.log.BufferedLogStreamReader;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.log.LogStreamBatchWriter;
import io.zeebe.logstreams.log.LogStreamBatchWriterImpl;
import io.zeebe.logstreams.log.LogStreamReader;
import io.zeebe.logstreams.log.LogStreamWriter;
import io.zeebe.logstreams.log.LoggedEvent;
import io.zeebe.logstreams.processor.EventProcessor;
import io.zeebe.logstreams.processor.StreamProcessor;
import io.zeebe.logstreams.processor.StreamProcessorContext;
import io.zeebe.logstreams.snapshot.ComposedZbMapSnapshot;
import io.zeebe.logstreams.snapshot.ZbMapSnapshotSupport;
import io.zeebe.logstreams.spi.SnapshotSupport;
import io.zeebe.msgpack.mapping.Mapping;
import io.zeebe.msgpack.mapping.MappingException;
import io.zeebe.msgpack.mapping.MappingProcessor;
import io.zeebe.protocol.clientapi.EventType;
import io.zeebe.protocol.impl.BrokerEventMetadata;
import io.zeebe.util.buffer.BufferReader;
import io.zeebe.util.buffer.BufferWriter;
import java.util.EnumMap;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class WorkflowInstanceStreamProcessor
implements StreamProcessor {
    private static final UnsafeBuffer EMPTY_TASK_TYPE = new UnsafeBuffer("".getBytes());
    protected final WorkflowCreatedEventProcessor workflowCreatedEventProcessor = new WorkflowCreatedEventProcessor();
    protected final CreateWorkflowInstanceEventProcessor createWorkflowInstanceEventProcessor = new CreateWorkflowInstanceEventProcessor();
    protected final WorkflowInstanceCreatedEventProcessor workflowInstanceCreatedEventProcessor = new WorkflowInstanceCreatedEventProcessor();
    protected final CancelWorkflowInstanceProcessor cancelWorkflowInstanceProcessor = new CancelWorkflowInstanceProcessor();
    protected final UpdatePayloadProcessor updatePayloadProcessor = new UpdatePayloadProcessor();
    protected final EventProcessor sequenceFlowTakenEventProcessor = new ActiveWorkflowInstanceProcessor(new SequenceFlowTakenEventProcessor());
    protected final EventProcessor activityReadyEventProcessor = new ActiveWorkflowInstanceProcessor(new ActivityReadyEventProcessor());
    protected final EventProcessor activityActivatedEventProcessor = new ActiveWorkflowInstanceProcessor(new ActivityActivatedEventProcessor());
    protected final EventProcessor activityCompletingEventProcessor = new ActiveWorkflowInstanceProcessor(new ActivityCompletingEventProcessor());
    protected final EventProcessor taskCompletedEventProcessor = new TaskCompletedEventProcessor();
    protected final EventProcessor taskCreatedEventProcessor = new TaskCreatedProcessor();
    protected final Map<BpmnAspect, EventProcessor> aspectHandlers = new EnumMap<BpmnAspect, EventProcessor>(BpmnAspect.class);
    protected final BrokerEventMetadata sourceEventMetadata;
    protected final BrokerEventMetadata targetEventMetadata;
    protected final WorkflowEvent workflowEvent;
    protected final WorkflowInstanceEvent workflowInstanceEvent;
    protected final TaskEvent taskEvent;
    protected final CommandResponseWriter responseWriter;
    protected final WorkflowInstanceIndex workflowInstanceIndex;
    protected final ActivityInstanceMap activityInstanceMap;
    protected final WorkflowDeploymentCache workflowDeploymentCache;
    protected final PayloadCache payloadCache;
    protected final ComposedZbMapSnapshot composedSnapshot;
    protected LogStreamReader logStreamReader;
    protected LogStreamBatchWriter logStreamBatchWriter;
    protected DirectBuffer logStreamTopicName;
    protected int logStreamPartitionId;
    protected int streamProcessorId;
    protected long eventKey;
    protected long eventPosition;
    protected final MappingProcessor payloadMappingProcessor;
    protected LogStream targetStream;

    public WorkflowInstanceStreamProcessor(CommandResponseWriter responseWriter, int deploymentCacheSize, int payloadCacheSize) {
        this.aspectHandlers.put(BpmnAspect.TAKE_SEQUENCE_FLOW, new ActiveWorkflowInstanceProcessor(new TakeSequenceFlowAspectHandler()));
        this.aspectHandlers.put(BpmnAspect.CONSUME_TOKEN, new ActiveWorkflowInstanceProcessor(new ConsumeTokenAspectHandler()));
        this.sourceEventMetadata = new BrokerEventMetadata();
        this.targetEventMetadata = new BrokerEventMetadata();
        this.workflowEvent = new WorkflowEvent();
        this.workflowInstanceEvent = new WorkflowInstanceEvent();
        this.taskEvent = new TaskEvent();
        this.responseWriter = responseWriter;
        this.logStreamReader = new BufferedLogStreamReader();
        this.workflowDeploymentCache = new WorkflowDeploymentCache(deploymentCacheSize, this.logStreamReader);
        this.payloadCache = new PayloadCache(payloadCacheSize, this.logStreamReader);
        this.workflowInstanceIndex = new WorkflowInstanceIndex();
        this.activityInstanceMap = new ActivityInstanceMap();
        this.payloadMappingProcessor = new MappingProcessor(4096);
        this.composedSnapshot = new ComposedZbMapSnapshot(new ZbMapSnapshotSupport[]{this.workflowInstanceIndex.getSnapshotSupport(), this.activityInstanceMap.getSnapshotSupport(), this.workflowDeploymentCache.getSnapshotSupport(), this.payloadCache.getSnapshotSupport()});
    }

    public int getPriority(long now) {
        return 100;
    }

    public SnapshotSupport getStateResource() {
        return this.composedSnapshot;
    }

    public void onOpen(StreamProcessorContext context) {
        LogStream sourceStream = context.getSourceStream();
        this.logStreamTopicName = sourceStream.getTopicName();
        this.logStreamPartitionId = sourceStream.getPartitionId();
        this.streamProcessorId = context.getId();
        this.logStreamReader.wrap(sourceStream);
        this.logStreamBatchWriter = new LogStreamBatchWriterImpl(context.getTargetStream());
        this.targetStream = context.getTargetStream();
    }

    public void onClose() {
        this.workflowInstanceIndex.close();
        this.activityInstanceMap.close();
        this.workflowDeploymentCache.close();
        this.payloadCache.close();
        this.logStreamReader.close();
    }

    public static MetadataFilter eventFilter() {
        return m -> m.getEventType() == EventType.WORKFLOW_INSTANCE_EVENT || m.getEventType() == EventType.TASK_EVENT || m.getEventType() == EventType.WORKFLOW_EVENT;
    }

    public EventProcessor onEvent(LoggedEvent event) {
        this.reset();
        this.eventKey = event.getKey();
        this.eventPosition = event.getPosition();
        this.sourceEventMetadata.reset();
        event.readMetadata((BufferReader)this.sourceEventMetadata);
        EventProcessor eventProcessor = null;
        switch (this.sourceEventMetadata.getEventType()) {
            case WORKFLOW_INSTANCE_EVENT: {
                eventProcessor = this.onWorkflowInstanceEvent(event);
                break;
            }
            case TASK_EVENT: {
                eventProcessor = this.onTaskEvent(event);
                break;
            }
            case WORKFLOW_EVENT: {
                eventProcessor = this.onWorkflowEvent(event);
                break;
            }
        }
        return eventProcessor;
    }

    protected void reset() {
        this.workflowInstanceIndex.reset();
        this.activityInstanceMap.reset();
    }

    protected EventProcessor onWorkflowInstanceEvent(LoggedEvent event) {
        this.workflowInstanceEvent.reset();
        event.readValue((BufferReader)this.workflowInstanceEvent);
        Object eventProcessor = null;
        switch (this.workflowInstanceEvent.getState()) {
            case CREATE_WORKFLOW_INSTANCE: {
                eventProcessor = this.createWorkflowInstanceEventProcessor;
                break;
            }
            case WORKFLOW_INSTANCE_CREATED: {
                eventProcessor = this.workflowInstanceCreatedEventProcessor;
                break;
            }
            case CANCEL_WORKFLOW_INSTANCE: {
                eventProcessor = this.cancelWorkflowInstanceProcessor;
                break;
            }
            case SEQUENCE_FLOW_TAKEN: {
                eventProcessor = this.sequenceFlowTakenEventProcessor;
                break;
            }
            case ACTIVITY_READY: {
                eventProcessor = this.activityReadyEventProcessor;
                break;
            }
            case ACTIVITY_ACTIVATED: {
                eventProcessor = this.activityActivatedEventProcessor;
                break;
            }
            case ACTIVITY_COMPLETING: {
                eventProcessor = this.activityCompletingEventProcessor;
                break;
            }
            case START_EVENT_OCCURRED: 
            case END_EVENT_OCCURRED: 
            case ACTIVITY_COMPLETED: {
                ExecutableFlowNode currentActivity = (ExecutableFlowNode)this.getCurrentActivity();
                eventProcessor = this.aspectHandlers.get((Object)currentActivity.getBpmnAspect());
                break;
            }
            case UPDATE_PAYLOAD: {
                eventProcessor = this.updatePayloadProcessor;
                break;
            }
        }
        return eventProcessor;
    }

    protected EventProcessor onTaskEvent(LoggedEvent event) {
        this.taskEvent.reset();
        event.readValue((BufferReader)this.taskEvent);
        switch (this.taskEvent.getState()) {
            case CREATED: {
                return this.taskCreatedEventProcessor;
            }
            case COMPLETED: {
                return this.taskCompletedEventProcessor;
            }
        }
        return null;
    }

    protected EventProcessor onWorkflowEvent(LoggedEvent event) {
        this.workflowEvent.reset();
        event.readValue((BufferReader)this.workflowEvent);
        switch (this.workflowEvent.getState()) {
            case CREATED: {
                return this.workflowCreatedEventProcessor;
            }
        }
        return null;
    }

    protected void lookupWorkflowInstanceEvent(long position) {
        boolean found = this.logStreamReader.seek(position);
        if (!found || !this.logStreamReader.hasNext()) {
            throw new IllegalStateException("workflow instance event not found.");
        }
        LoggedEvent event = (LoggedEvent)this.logStreamReader.next();
        this.workflowInstanceEvent.reset();
        event.readValue((BufferReader)this.workflowInstanceEvent);
    }

    protected <T extends ExecutableFlowElement> T getCurrentActivity() {
        long workflowKey = this.workflowInstanceEvent.getWorkflowKey();
        ExecutableWorkflow workflow = this.workflowDeploymentCache.getWorkflow(workflowKey);
        if (workflow != null) {
            DirectBuffer currentActivityId = this.workflowInstanceEvent.getActivityId();
            return workflow.getChildById(currentActivityId);
        }
        throw new RuntimeException("No workflow found for key: " + workflowKey);
    }

    protected long writeWorkflowEvent(LogStreamWriter writer) {
        this.targetEventMetadata.reset();
        this.targetEventMetadata.protocolVersion(1).eventType(EventType.WORKFLOW_INSTANCE_EVENT).raftTermId(this.targetStream.getTerm());
        return writer.metadataWriter((BufferWriter)this.targetEventMetadata).valueWriter((BufferWriter)this.workflowInstanceEvent).tryWrite();
    }

    protected long writeTaskEvent(LogStreamWriter writer) {
        this.targetEventMetadata.reset();
        this.targetEventMetadata.protocolVersion(1).eventType(EventType.TASK_EVENT).raftTermId(this.targetStream.getTerm());
        return writer.metadataWriter((BufferWriter)this.targetEventMetadata).valueWriter((BufferWriter)this.taskEvent).tryWrite();
    }

    protected boolean sendWorkflowInstanceResponse() {
        return this.responseWriter.topicName(this.logStreamTopicName).partitionId(this.logStreamPartitionId).position(this.eventPosition).key(this.eventKey).eventWriter((BufferWriter)this.workflowInstanceEvent).tryWriteResponse(this.sourceEventMetadata.getRequestStreamId(), this.sourceEventMetadata.getRequestId());
    }

    private final class ActiveWorkflowInstanceProcessor
    implements EventProcessor {
        private final EventProcessor processor;
        private boolean isActive;

        ActiveWorkflowInstanceProcessor(EventProcessor processor) {
            this.processor = processor;
        }

        public void processEvent() {
            boolean bl = this.isActive = WorkflowInstanceStreamProcessor.this.workflowInstanceIndex.wrapWorkflowInstanceKey(WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getWorkflowInstanceKey()).getTokenCount() > 0;
            if (this.isActive) {
                this.processor.processEvent();
            }
        }

        public boolean executeSideEffects() {
            return this.isActive ? this.processor.executeSideEffects() : true;
        }

        public long writeEvent(LogStreamWriter writer) {
            return this.isActive ? this.processor.writeEvent(writer) : 0L;
        }

        public void updateState() {
            if (this.isActive) {
                this.processor.updateState();
            }
        }
    }

    private final class UpdatePayloadProcessor
    implements EventProcessor {
        private boolean isUpdated;

        private UpdatePayloadProcessor() {
        }

        public void processEvent() {
            DirectBuffer payload;
            this.isUpdated = false;
            long currentActivityInstanceKey = WorkflowInstanceStreamProcessor.this.workflowInstanceIndex.wrapWorkflowInstanceKey(WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getWorkflowInstanceKey()).getActivityInstanceKey();
            WorkflowInstanceState workflowInstanceEventType = WorkflowInstanceState.UPDATE_PAYLOAD_REJECTED;
            if (currentActivityInstanceKey > 0L && currentActivityInstanceKey == WorkflowInstanceStreamProcessor.this.eventKey && PayloadUtil.isValidPayload(payload = WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getPayload())) {
                workflowInstanceEventType = WorkflowInstanceState.PAYLOAD_UPDATED;
                this.isUpdated = true;
            }
            WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.setState(workflowInstanceEventType);
        }

        public boolean executeSideEffects() {
            return WorkflowInstanceStreamProcessor.this.sendWorkflowInstanceResponse();
        }

        public long writeEvent(LogStreamWriter writer) {
            return WorkflowInstanceStreamProcessor.this.writeWorkflowEvent(writer.key(WorkflowInstanceStreamProcessor.this.eventKey));
        }

        public void updateState() {
            if (this.isUpdated) {
                WorkflowInstanceStreamProcessor.this.payloadCache.addPayload(WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getWorkflowInstanceKey(), WorkflowInstanceStreamProcessor.this.eventPosition, WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getPayload());
            }
        }
    }

    private final class CancelWorkflowInstanceProcessor
    implements EventProcessor {
        private final WorkflowInstanceEvent activityInstanceEvent = new WorkflowInstanceEvent();
        private boolean isCanceled;
        private long activityInstanceKey;
        private long taskKey;

        private CancelWorkflowInstanceProcessor() {
        }

        public void processEvent() {
            this.isCanceled = false;
            WorkflowInstanceStreamProcessor.this.workflowInstanceIndex.wrapWorkflowInstanceKey(WorkflowInstanceStreamProcessor.this.eventKey);
            if (WorkflowInstanceStreamProcessor.this.workflowInstanceIndex.getTokenCount() > 0) {
                WorkflowInstanceStreamProcessor.this.lookupWorkflowInstanceEvent(WorkflowInstanceStreamProcessor.this.workflowInstanceIndex.getPosition());
                WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.setState(WorkflowInstanceState.WORKFLOW_INSTANCE_CANCELED).setPayload(WorkflowInstanceEvent.NO_PAYLOAD);
                this.activityInstanceKey = WorkflowInstanceStreamProcessor.this.workflowInstanceIndex.getActivityInstanceKey();
                this.taskKey = WorkflowInstanceStreamProcessor.this.activityInstanceMap.wrapActivityInstanceKey(this.activityInstanceKey).getTaskKey();
                this.isCanceled = true;
            } else {
                WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.setState(WorkflowInstanceState.CANCEL_WORKFLOW_INSTANCE_REJECTED);
            }
        }

        public long writeEvent(LogStreamWriter writer) {
            WorkflowInstanceStreamProcessor.this.logStreamBatchWriter.producerId(WorkflowInstanceStreamProcessor.this.streamProcessorId).sourceEvent(WorkflowInstanceStreamProcessor.this.logStreamTopicName, WorkflowInstanceStreamProcessor.this.logStreamPartitionId, WorkflowInstanceStreamProcessor.this.eventPosition);
            if (this.taskKey > 0L) {
                this.writeCancelTaskEvent(WorkflowInstanceStreamProcessor.this.logStreamBatchWriter.event(), this.taskKey);
            }
            if (this.activityInstanceKey > 0L) {
                this.writeTerminateActivityInstanceEvent(WorkflowInstanceStreamProcessor.this.logStreamBatchWriter.event(), this.activityInstanceKey);
            }
            this.writeWorklowInstanceEvent(WorkflowInstanceStreamProcessor.this.logStreamBatchWriter.event());
            return WorkflowInstanceStreamProcessor.this.logStreamBatchWriter.tryWrite();
        }

        private void writeWorklowInstanceEvent(LogStreamBatchWriter.LogEntryBuilder logEntryBuilder) {
            WorkflowInstanceStreamProcessor.this.targetEventMetadata.reset();
            WorkflowInstanceStreamProcessor.this.targetEventMetadata.protocolVersion(1).raftTermId(WorkflowInstanceStreamProcessor.this.targetStream.getTerm()).eventType(EventType.WORKFLOW_INSTANCE_EVENT);
            logEntryBuilder.key(WorkflowInstanceStreamProcessor.this.eventKey).metadataWriter((BufferWriter)WorkflowInstanceStreamProcessor.this.targetEventMetadata).valueWriter((BufferWriter)WorkflowInstanceStreamProcessor.this.workflowInstanceEvent).done();
        }

        private void writeCancelTaskEvent(LogStreamBatchWriter.LogEntryBuilder logEntryBuilder, long taskKey) {
            WorkflowInstanceStreamProcessor.this.targetEventMetadata.reset();
            WorkflowInstanceStreamProcessor.this.targetEventMetadata.protocolVersion(1).raftTermId(WorkflowInstanceStreamProcessor.this.targetStream.getTerm()).eventType(EventType.TASK_EVENT);
            WorkflowInstanceStreamProcessor.this.taskEvent.reset();
            WorkflowInstanceStreamProcessor.this.taskEvent.setState(TaskState.CANCEL).setType((DirectBuffer)EMPTY_TASK_TYPE).headers().setBpmnProcessId(WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getBpmnProcessId()).setWorkflowDefinitionVersion(WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getVersion()).setWorkflowInstanceKey(WorkflowInstanceStreamProcessor.this.eventKey).setActivityId(WorkflowInstanceStreamProcessor.this.activityInstanceMap.getActivityId()).setActivityInstanceKey(this.activityInstanceKey);
            logEntryBuilder.key(taskKey).metadataWriter((BufferWriter)WorkflowInstanceStreamProcessor.this.targetEventMetadata).valueWriter((BufferWriter)WorkflowInstanceStreamProcessor.this.taskEvent).done();
        }

        private void writeTerminateActivityInstanceEvent(LogStreamBatchWriter.LogEntryBuilder logEntryBuilder, long activityInstanceKey) {
            WorkflowInstanceStreamProcessor.this.targetEventMetadata.reset();
            WorkflowInstanceStreamProcessor.this.targetEventMetadata.protocolVersion(1).raftTermId(WorkflowInstanceStreamProcessor.this.targetStream.getTerm()).eventType(EventType.WORKFLOW_INSTANCE_EVENT);
            this.activityInstanceEvent.reset();
            this.activityInstanceEvent.setState(WorkflowInstanceState.ACTIVITY_TERMINATED).setBpmnProcessId(WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getBpmnProcessId()).setVersion(WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getVersion()).setWorkflowInstanceKey(WorkflowInstanceStreamProcessor.this.eventKey).setActivityId(WorkflowInstanceStreamProcessor.this.activityInstanceMap.getActivityId());
            logEntryBuilder.key(activityInstanceKey).metadataWriter((BufferWriter)WorkflowInstanceStreamProcessor.this.targetEventMetadata).valueWriter((BufferWriter)this.activityInstanceEvent).done();
        }

        public boolean executeSideEffects() {
            return WorkflowInstanceStreamProcessor.this.sendWorkflowInstanceResponse();
        }

        public void updateState() {
            if (this.isCanceled) {
                WorkflowInstanceStreamProcessor.this.workflowInstanceIndex.remove(WorkflowInstanceStreamProcessor.this.eventKey);
                WorkflowInstanceStreamProcessor.this.payloadCache.remove(WorkflowInstanceStreamProcessor.this.eventKey);
                WorkflowInstanceStreamProcessor.this.activityInstanceMap.remove(this.activityInstanceKey);
            }
        }
    }

    private final class ActivityCompletingEventProcessor
    implements EventProcessor {
        public static final String INCIDENT_ERROR_MSG_MISSING_TASK_PAYLOAD_ON_OUT_MAPPING = "Task was completed without an payload - processing of output mapping failed!";

        private ActivityCompletingEventProcessor() {
        }

        public void processEvent() {
            ExecutableServiceTask serviceTask = (ExecutableServiceTask)WorkflowInstanceStreamProcessor.this.getCurrentActivity();
            WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.setState(WorkflowInstanceState.ACTIVITY_COMPLETED);
            this.setWorkflowInstancePayload(serviceTask.getIoMapping().getOutputMappings());
        }

        private void setWorkflowInstancePayload(Mapping[] mappings) {
            DirectBuffer workflowInstancePayload = WorkflowInstanceStreamProcessor.this.payloadCache.getPayload(WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getWorkflowInstanceKey());
            DirectBuffer taskPayload = WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getPayload();
            boolean isNilPayload = PayloadUtil.isNilPayload(taskPayload);
            if (mappings.length > 0) {
                if (isNilPayload) {
                    throw new MappingException(INCIDENT_ERROR_MSG_MISSING_TASK_PAYLOAD_ON_OUT_MAPPING);
                }
                int resultLen = WorkflowInstanceStreamProcessor.this.payloadMappingProcessor.merge(taskPayload, workflowInstancePayload, mappings);
                MutableDirectBuffer buffer = WorkflowInstanceStreamProcessor.this.payloadMappingProcessor.getResultBuffer();
                WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.setPayload((DirectBuffer)buffer, 0, resultLen);
            } else if (isNilPayload) {
                WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.setPayload(workflowInstancePayload, 0, workflowInstancePayload.capacity());
            }
        }

        public long writeEvent(LogStreamWriter writer) {
            return WorkflowInstanceStreamProcessor.this.writeWorkflowEvent(writer.key(WorkflowInstanceStreamProcessor.this.eventKey));
        }

        public void updateState() {
            WorkflowInstanceStreamProcessor.this.workflowInstanceIndex.wrapWorkflowInstanceKey(WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getWorkflowInstanceKey()).setActivityKey(-1L).write();
            WorkflowInstanceStreamProcessor.this.activityInstanceMap.remove(WorkflowInstanceStreamProcessor.this.eventKey);
        }
    }

    private final class TaskCompletedEventProcessor
    implements EventProcessor {
        private boolean isActivityCompleted;
        private long activityInstanceKey;

        private TaskCompletedEventProcessor() {
        }

        public void processEvent() {
            this.isActivityCompleted = false;
            TaskHeaders taskHeaders = WorkflowInstanceStreamProcessor.this.taskEvent.headers();
            this.activityInstanceKey = taskHeaders.getActivityInstanceKey();
            if (taskHeaders.getWorkflowInstanceKey() > 0L && this.isTaskOpen(this.activityInstanceKey)) {
                WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.setState(WorkflowInstanceState.ACTIVITY_COMPLETING).setBpmnProcessId(taskHeaders.getBpmnProcessId()).setVersion(taskHeaders.getWorkflowDefinitionVersion()).setWorkflowKey(taskHeaders.getWorkflowKey()).setWorkflowInstanceKey(taskHeaders.getWorkflowInstanceKey()).setActivityId(taskHeaders.getActivityId()).setPayload(WorkflowInstanceStreamProcessor.this.taskEvent.getPayload());
                this.isActivityCompleted = true;
            }
        }

        private boolean isTaskOpen(long activityInstanceKey) {
            return WorkflowInstanceStreamProcessor.this.activityInstanceMap.wrapActivityInstanceKey(activityInstanceKey).getTaskKey() == WorkflowInstanceStreamProcessor.this.eventKey;
        }

        public long writeEvent(LogStreamWriter writer) {
            return this.isActivityCompleted ? WorkflowInstanceStreamProcessor.this.writeWorkflowEvent(writer.key(this.activityInstanceKey)) : 0L;
        }

        public void updateState() {
            if (this.isActivityCompleted) {
                WorkflowInstanceStreamProcessor.this.activityInstanceMap.setTaskKey(-1L).write();
            }
        }
    }

    private final class TaskCreatedProcessor
    implements EventProcessor {
        private boolean isActive;

        private TaskCreatedProcessor() {
        }

        public void processEvent() {
            this.isActive = false;
            TaskHeaders taskHeaders = WorkflowInstanceStreamProcessor.this.taskEvent.headers();
            long activityInstanceKey = taskHeaders.getActivityInstanceKey();
            if (activityInstanceKey > 0L) {
                long currentActivityInstanceKey = WorkflowInstanceStreamProcessor.this.workflowInstanceIndex.wrapWorkflowInstanceKey(taskHeaders.getWorkflowInstanceKey()).getActivityInstanceKey();
                this.isActive = activityInstanceKey == currentActivityInstanceKey;
            }
        }

        public void updateState() {
            if (this.isActive) {
                WorkflowInstanceStreamProcessor.this.activityInstanceMap.wrapActivityInstanceKey(WorkflowInstanceStreamProcessor.this.taskEvent.headers().getActivityInstanceKey()).setTaskKey(WorkflowInstanceStreamProcessor.this.eventKey).write();
            }
        }
    }

    private final class ActivityActivatedEventProcessor
    implements EventProcessor {
        private ActivityActivatedEventProcessor() {
        }

        public void processEvent() {
            ExecutableServiceTask serviceTask = (ExecutableServiceTask)WorkflowInstanceStreamProcessor.this.getCurrentActivity();
            TaskMetadata taskMetadata = serviceTask.getTaskMetadata();
            WorkflowInstanceStreamProcessor.this.taskEvent.reset();
            WorkflowInstanceStreamProcessor.this.taskEvent.setState(TaskState.CREATE).setType(taskMetadata.getTaskType()).setRetries(taskMetadata.getRetries()).setPayload(WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getPayload());
            this.setTaskHeaders(serviceTask, taskMetadata);
        }

        private void setTaskHeaders(ExecutableServiceTask serviceTask, TaskMetadata taskMetadata) {
            TaskHeaders taskHeaders = WorkflowInstanceStreamProcessor.this.taskEvent.headers().setBpmnProcessId(WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getBpmnProcessId()).setWorkflowDefinitionVersion(WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getVersion()).setWorkflowKey(WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getWorkflowKey()).setWorkflowInstanceKey(WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getWorkflowInstanceKey()).setActivityId(serviceTask.getId()).setActivityInstanceKey(WorkflowInstanceStreamProcessor.this.eventKey);
            DirectBuffer customHeaders = taskMetadata.getHeaders();
            if (customHeaders.capacity() > 0) {
                WorkflowInstanceStreamProcessor.this.taskEvent.setCustomHeaders(customHeaders);
            }
        }

        public long writeEvent(LogStreamWriter writer) {
            return WorkflowInstanceStreamProcessor.this.writeTaskEvent(writer.positionAsKey());
        }
    }

    private final class ActivityReadyEventProcessor
    implements EventProcessor {
        private final DirectBuffer sourcePayload = new UnsafeBuffer(0L, 0);

        private ActivityReadyEventProcessor() {
        }

        public void processEvent() {
            Object activty = WorkflowInstanceStreamProcessor.this.getCurrentActivity();
            if (activty instanceof ExecutableServiceTask) {
                ExecutableServiceTask serviceTask = (ExecutableServiceTask)activty;
                WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.setState(WorkflowInstanceState.ACTIVITY_ACTIVATED);
                try {
                    this.setWorkflowInstancePayload(serviceTask.getIoMapping().getInputMappings());
                }
                catch (Exception e) {
                    this.updateState();
                    throw e;
                }
            } else {
                throw new RuntimeException("Currently not supported. An activity must be of type service task.");
            }
        }

        private void setWorkflowInstancePayload(Mapping[] mappings) {
            this.sourcePayload.wrap(WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getPayload());
            if (mappings.length > 0) {
                int resultLen = WorkflowInstanceStreamProcessor.this.payloadMappingProcessor.extract(this.sourcePayload, mappings);
                MutableDirectBuffer buffer = WorkflowInstanceStreamProcessor.this.payloadMappingProcessor.getResultBuffer();
                WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.setPayload((DirectBuffer)buffer, 0, resultLen);
            }
        }

        public long writeEvent(LogStreamWriter writer) {
            return WorkflowInstanceStreamProcessor.this.writeWorkflowEvent(writer.key(WorkflowInstanceStreamProcessor.this.eventKey));
        }

        public void updateState() {
            WorkflowInstanceStreamProcessor.this.workflowInstanceIndex.wrapWorkflowInstanceKey(WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getWorkflowInstanceKey()).setActivityKey(WorkflowInstanceStreamProcessor.this.eventKey).write();
            WorkflowInstanceStreamProcessor.this.activityInstanceMap.newActivityInstance(WorkflowInstanceStreamProcessor.this.eventKey).setActivityId(WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getActivityId()).setTaskKey(-1L).write();
            if (!PayloadUtil.isNilPayload(this.sourcePayload)) {
                WorkflowInstanceStreamProcessor.this.payloadCache.addPayload(WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getWorkflowInstanceKey(), WorkflowInstanceStreamProcessor.this.eventPosition, this.sourcePayload);
            }
        }
    }

    private final class SequenceFlowTakenEventProcessor
    implements EventProcessor {
        private SequenceFlowTakenEventProcessor() {
        }

        public void processEvent() {
            ExecutableSequenceFlow sequenceFlow = (ExecutableSequenceFlow)WorkflowInstanceStreamProcessor.this.getCurrentActivity();
            ExecutableFlowNode targetNode = sequenceFlow.getTargetNode();
            WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.setActivityId(targetNode.getId());
            if (targetNode instanceof ExecutableEndEvent) {
                WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.setState(WorkflowInstanceState.END_EVENT_OCCURRED);
            } else if (targetNode instanceof ExecutableServiceTask) {
                WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.setState(WorkflowInstanceState.ACTIVITY_READY);
            } else {
                throw new RuntimeException("Currently not supported. A sequence flow must end in an end event or service task.");
            }
        }

        public long writeEvent(LogStreamWriter writer) {
            return WorkflowInstanceStreamProcessor.this.writeWorkflowEvent(writer.positionAsKey());
        }
    }

    private final class ConsumeTokenAspectHandler
    implements EventProcessor {
        private boolean isCompleted;
        private int activeTokenCount;

        private ConsumeTokenAspectHandler() {
        }

        public void processEvent() {
            this.isCompleted = false;
            this.activeTokenCount = WorkflowInstanceStreamProcessor.this.workflowInstanceIndex.wrapWorkflowInstanceKey(WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getWorkflowInstanceKey()).getTokenCount();
            if (this.activeTokenCount == 1) {
                WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.setState(WorkflowInstanceState.WORKFLOW_INSTANCE_COMPLETED).setActivityId("");
                this.isCompleted = true;
            }
        }

        public long writeEvent(LogStreamWriter writer) {
            long position = 0L;
            if (this.isCompleted) {
                position = WorkflowInstanceStreamProcessor.this.writeWorkflowEvent(writer.key(WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getWorkflowInstanceKey().longValue()));
            }
            return position;
        }

        public void updateState() {
            if (this.isCompleted) {
                WorkflowInstanceStreamProcessor.this.workflowInstanceIndex.remove(WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getWorkflowInstanceKey());
                WorkflowInstanceStreamProcessor.this.payloadCache.remove(WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getWorkflowInstanceKey());
            } else {
                WorkflowInstanceStreamProcessor.this.workflowInstanceIndex.setActiveTokenCount(this.activeTokenCount - 1).write();
            }
        }
    }

    private final class TakeSequenceFlowAspectHandler
    implements EventProcessor {
        private TakeSequenceFlowAspectHandler() {
        }

        public void processEvent() {
            ExecutableFlowNode currentActivity = (ExecutableFlowNode)WorkflowInstanceStreamProcessor.this.getCurrentActivity();
            ExecutableSequenceFlow sequenceFlow = currentActivity.getOutgoingSequenceFlows()[0];
            WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.setState(WorkflowInstanceState.SEQUENCE_FLOW_TAKEN).setActivityId(sequenceFlow.getId());
        }

        public long writeEvent(LogStreamWriter writer) {
            return WorkflowInstanceStreamProcessor.this.writeWorkflowEvent(writer.positionAsKey());
        }
    }

    private final class WorkflowInstanceCreatedEventProcessor
    implements EventProcessor {
        private WorkflowInstanceCreatedEventProcessor() {
        }

        public void processEvent() {
            long workflowKey = WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getWorkflowKey();
            ExecutableWorkflow workflow = WorkflowInstanceStreamProcessor.this.workflowDeploymentCache.getWorkflow(workflowKey);
            if (workflow == null) {
                throw new RuntimeException("No workflow found for key: " + workflowKey);
            }
            ExecutableStartEvent startEvent = workflow.getScopeStartEvent();
            DirectBuffer activityId = startEvent.getId();
            WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.setState(WorkflowInstanceState.START_EVENT_OCCURRED).setWorkflowInstanceKey(WorkflowInstanceStreamProcessor.this.eventKey).setActivityId(activityId);
        }

        public long writeEvent(LogStreamWriter writer) {
            return WorkflowInstanceStreamProcessor.this.writeWorkflowEvent(writer.positionAsKey());
        }

        public void updateState() {
            WorkflowInstanceStreamProcessor.this.workflowInstanceIndex.newWorkflowInstance(WorkflowInstanceStreamProcessor.this.eventKey).setPosition(WorkflowInstanceStreamProcessor.this.eventPosition).setActiveTokenCount(1).setActivityKey(-1L).write();
        }
    }

    private final class CreateWorkflowInstanceEventProcessor
    implements EventProcessor {
        private CreateWorkflowInstanceEventProcessor() {
        }

        public void processEvent() {
            WorkflowInstanceState newEventType = WorkflowInstanceState.WORKFLOW_INSTANCE_REJECTED;
            long workflowKey = WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getWorkflowKey();
            DirectBuffer bpmnProcessId = WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getBpmnProcessId();
            int version = WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getVersion();
            if (workflowKey <= 0L) {
                workflowKey = version > 0 ? WorkflowInstanceStreamProcessor.this.workflowDeploymentCache.getWorkflowKeyByIdAndVersion(bpmnProcessId, version) : WorkflowInstanceStreamProcessor.this.workflowDeploymentCache.getWorkflowKeyByIdAndLatestVersion(bpmnProcessId);
            }
            if (workflowKey > 0L) {
                ExecutableWorkflow workflow = WorkflowInstanceStreamProcessor.this.workflowDeploymentCache.getWorkflow(workflowKey);
                DirectBuffer payload = WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.getPayload();
                if (workflow != null && (PayloadUtil.isNilPayload(payload) || PayloadUtil.isValidPayload(payload))) {
                    WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.setWorkflowKey(workflowKey).setBpmnProcessId(workflow.getId()).setVersion(workflow.getVersion());
                    newEventType = WorkflowInstanceState.WORKFLOW_INSTANCE_CREATED;
                }
            }
            WorkflowInstanceStreamProcessor.this.workflowInstanceEvent.setState(newEventType).setWorkflowInstanceKey(WorkflowInstanceStreamProcessor.this.eventKey);
        }

        public boolean executeSideEffects() {
            return WorkflowInstanceStreamProcessor.this.sendWorkflowInstanceResponse();
        }

        public long writeEvent(LogStreamWriter writer) {
            return WorkflowInstanceStreamProcessor.this.writeWorkflowEvent(writer.key(WorkflowInstanceStreamProcessor.this.eventKey));
        }
    }

    private final class WorkflowCreatedEventProcessor
    implements EventProcessor {
        private WorkflowCreatedEventProcessor() {
        }

        public void processEvent() {
            if (WorkflowInstanceStreamProcessor.this.eventKey != WorkflowInstanceStreamProcessor.this.eventPosition) {
                throw new RuntimeException("The workflow event position is not equal to the key, but the implementation based on it.");
            }
        }

        public void updateState() {
            int version = WorkflowInstanceStreamProcessor.this.workflowEvent.getVersion();
            DirectBuffer bpmnProcessId = WorkflowInstanceStreamProcessor.this.workflowEvent.getBpmnProcessId();
            WorkflowInstanceStreamProcessor.this.workflowDeploymentCache.addDeployedWorkflow(WorkflowInstanceStreamProcessor.this.eventKey, bpmnProcessId, version);
        }
    }
}

