/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.clustering.gossip;

import io.zeebe.clustering.gossip.EndpointType;
import io.zeebe.clustering.gossip.GossipDecoder;
import io.zeebe.clustering.gossip.GroupSizeEncodingEncoder;
import io.zeebe.clustering.gossip.MetaAttribute;
import io.zeebe.clustering.gossip.PeerState;
import io.zeebe.clustering.gossip.RaftMembershipState;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;

public class GossipEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 0;
    public static final int TEMPLATE_ID = 0;
    public static final int SCHEMA_ID = 3;
    public static final int SCHEMA_VERSION = 1;
    private final GossipEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;
    private final PeersEncoder peers = new PeersEncoder();

    public int sbeBlockLength() {
        return 0;
    }

    public int sbeTemplateId() {
        return 0;
    }

    public int sbeSchemaId() {
        return 3;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public GossipEncoder wrap(MutableDirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        this.limit(offset + 0);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static long peersId() {
        return 1L;
    }

    public PeersEncoder peersCount(int count) {
        this.peers.wrap(this.parentMessage, this.buffer, count);
        return this.peers;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        GossipDecoder writer = new GossipDecoder();
        writer.wrap((DirectBuffer)this.buffer, this.offset, 0, 1);
        return writer.appendTo(builder);
    }

    public static class PeersEncoder {
        private static final int HEADER_SIZE = 3;
        private final GroupSizeEncodingEncoder dimensions = new GroupSizeEncodingEncoder();
        private GossipEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private final EndpointsEncoder endpoints = new EndpointsEncoder();
        private final RaftMembershipsEncoder raftMemberships = new RaftMembershipsEncoder();

        public void wrap(GossipEncoder parentMessage, MutableDirectBuffer buffer, int count) {
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            this.parentMessage = parentMessage;
            this.buffer = buffer;
            this.dimensions.wrap(buffer, parentMessage.limit());
            this.dimensions.blockLength(11);
            this.dimensions.numInGroup((short)count);
            this.index = -1;
            this.count = count;
            parentMessage.limit(parentMessage.limit() + 3);
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 11;
        }

        public PeersEncoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + PeersEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public static int stateEncodingOffset() {
            return 0;
        }

        public static int stateEncodingLength() {
            return 1;
        }

        public PeersEncoder state(PeerState value) {
            this.buffer.putByte(this.offset + 0, (byte)value.value());
            return this;
        }

        public static int generationEncodingOffset() {
            return 1;
        }

        public static int generationEncodingLength() {
            return 8;
        }

        public static long generationNullValue() {
            return -1L;
        }

        public static long generationMinValue() {
            return 0L;
        }

        public static long generationMaxValue() {
            return -2L;
        }

        public PeersEncoder generation(long value) {
            this.buffer.putLong(this.offset + 1, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int versionEncodingOffset() {
            return 9;
        }

        public static int versionEncodingLength() {
            return 2;
        }

        public static int versionNullValue() {
            return 65535;
        }

        public static int versionMinValue() {
            return 0;
        }

        public static int versionMaxValue() {
            return 65534;
        }

        public PeersEncoder version(int value) {
            this.buffer.putShort(this.offset + 9, (short)value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static long endpointsId() {
            return 5L;
        }

        public EndpointsEncoder endpointsCount(int count) {
            this.endpoints.wrap(this.parentMessage, this.buffer, count);
            return this.endpoints;
        }

        public static long raftMembershipsId() {
            return 9L;
        }

        public RaftMembershipsEncoder raftMembershipsCount(int count) {
            this.raftMemberships.wrap(this.parentMessage, this.buffer, count);
            return this.raftMemberships;
        }

        public static class RaftMembershipsEncoder {
            private static final int HEADER_SIZE = 3;
            private final GroupSizeEncodingEncoder dimensions = new GroupSizeEncodingEncoder();
            private GossipEncoder parentMessage;
            private MutableDirectBuffer buffer;
            private int count;
            private int index;
            private int offset;

            public void wrap(GossipEncoder parentMessage, MutableDirectBuffer buffer, int count) {
                if (count < 0 || count > 254) {
                    throw new IllegalArgumentException("count outside allowed range: count=" + count);
                }
                this.parentMessage = parentMessage;
                this.buffer = buffer;
                this.dimensions.wrap(buffer, parentMessage.limit());
                this.dimensions.blockLength(5);
                this.dimensions.numInGroup((short)count);
                this.index = -1;
                this.count = count;
                parentMessage.limit(parentMessage.limit() + 3);
            }

            public static int sbeHeaderSize() {
                return 3;
            }

            public static int sbeBlockLength() {
                return 5;
            }

            public RaftMembershipsEncoder next() {
                if (this.index + 1 >= this.count) {
                    throw new NoSuchElementException();
                }
                this.offset = this.parentMessage.limit();
                this.parentMessage.limit(this.offset + RaftMembershipsEncoder.sbeBlockLength());
                ++this.index;
                return this;
            }

            public static int partitionIdEncodingOffset() {
                return 0;
            }

            public static int partitionIdEncodingLength() {
                return 2;
            }

            public static int partitionIdNullValue() {
                return 65535;
            }

            public static int partitionIdMinValue() {
                return 0;
            }

            public static int partitionIdMaxValue() {
                return 65534;
            }

            public RaftMembershipsEncoder partitionId(int value) {
                this.buffer.putShort(this.offset + 0, (short)value, ByteOrder.LITTLE_ENDIAN);
                return this;
            }

            public static int termEncodingOffset() {
                return 2;
            }

            public static int termEncodingLength() {
                return 2;
            }

            public static int termNullValue() {
                return 65535;
            }

            public static int termMinValue() {
                return 0;
            }

            public static int termMaxValue() {
                return 65534;
            }

            public RaftMembershipsEncoder term(int value) {
                this.buffer.putShort(this.offset + 2, (short)value, ByteOrder.LITTLE_ENDIAN);
                return this;
            }

            public static int stateEncodingOffset() {
                return 4;
            }

            public static int stateEncodingLength() {
                return 1;
            }

            public RaftMembershipsEncoder state(RaftMembershipState value) {
                this.buffer.putByte(this.offset + 4, (byte)value.value());
                return this;
            }

            public static int topicNameId() {
                return 13;
            }

            public static String topicNameCharacterEncoding() {
                return "UTF-8";
            }

            public static String topicNameMetaAttribute(MetaAttribute metaAttribute) {
                switch (metaAttribute) {
                    case EPOCH: {
                        return "unix";
                    }
                    case TIME_UNIT: {
                        return "nanosecond";
                    }
                    case SEMANTIC_TYPE: {
                        return "";
                    }
                }
                return "";
            }

            public static int topicNameHeaderLength() {
                return 2;
            }

            public RaftMembershipsEncoder putTopicName(DirectBuffer src, int srcOffset, int length) {
                if (length > 65534) {
                    throw new IllegalArgumentException("length > max value for type: " + length);
                }
                int headerLength = 2;
                int limit = this.parentMessage.limit();
                this.parentMessage.limit(limit + 2 + length);
                this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
                this.buffer.putBytes(limit + 2, src, srcOffset, length);
                return this;
            }

            public RaftMembershipsEncoder putTopicName(byte[] src, int srcOffset, int length) {
                if (length > 65534) {
                    throw new IllegalArgumentException("length > max value for type: " + length);
                }
                int headerLength = 2;
                int limit = this.parentMessage.limit();
                this.parentMessage.limit(limit + 2 + length);
                this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
                this.buffer.putBytes(limit + 2, src, srcOffset, length);
                return this;
            }

            public RaftMembershipsEncoder topicName(String value) {
                byte[] bytes;
                try {
                    bytes = value.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException(ex);
                }
                int length = bytes.length;
                if (length > 65534) {
                    throw new IllegalArgumentException("length > max value for type: " + length);
                }
                int headerLength = 2;
                int limit = this.parentMessage.limit();
                this.parentMessage.limit(limit + 2 + length);
                this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
                this.buffer.putBytes(limit + 2, bytes, 0, length);
                return this;
            }
        }

        public static class EndpointsEncoder {
            private static final int HEADER_SIZE = 3;
            private final GroupSizeEncodingEncoder dimensions = new GroupSizeEncodingEncoder();
            private GossipEncoder parentMessage;
            private MutableDirectBuffer buffer;
            private int count;
            private int index;
            private int offset;

            public void wrap(GossipEncoder parentMessage, MutableDirectBuffer buffer, int count) {
                if (count < 0 || count > 254) {
                    throw new IllegalArgumentException("count outside allowed range: count=" + count);
                }
                this.parentMessage = parentMessage;
                this.buffer = buffer;
                this.dimensions.wrap(buffer, parentMessage.limit());
                this.dimensions.blockLength(3);
                this.dimensions.numInGroup((short)count);
                this.index = -1;
                this.count = count;
                parentMessage.limit(parentMessage.limit() + 3);
            }

            public static int sbeHeaderSize() {
                return 3;
            }

            public static int sbeBlockLength() {
                return 3;
            }

            public EndpointsEncoder next() {
                if (this.index + 1 >= this.count) {
                    throw new NoSuchElementException();
                }
                this.offset = this.parentMessage.limit();
                this.parentMessage.limit(this.offset + EndpointsEncoder.sbeBlockLength());
                ++this.index;
                return this;
            }

            public static int endpointTypeEncodingOffset() {
                return 0;
            }

            public static int endpointTypeEncodingLength() {
                return 1;
            }

            public EndpointsEncoder endpointType(EndpointType value) {
                this.buffer.putByte(this.offset + 0, (byte)value.value());
                return this;
            }

            public static int portEncodingOffset() {
                return 1;
            }

            public static int portEncodingLength() {
                return 2;
            }

            public static int portNullValue() {
                return 65535;
            }

            public static int portMinValue() {
                return 0;
            }

            public static int portMaxValue() {
                return 65534;
            }

            public EndpointsEncoder port(int value) {
                this.buffer.putShort(this.offset + 1, (short)value, ByteOrder.LITTLE_ENDIAN);
                return this;
            }

            public static int hostId() {
                return 8;
            }

            public static String hostCharacterEncoding() {
                return "UTF-8";
            }

            public static String hostMetaAttribute(MetaAttribute metaAttribute) {
                switch (metaAttribute) {
                    case EPOCH: {
                        return "unix";
                    }
                    case TIME_UNIT: {
                        return "nanosecond";
                    }
                    case SEMANTIC_TYPE: {
                        return "";
                    }
                }
                return "";
            }

            public static int hostHeaderLength() {
                return 2;
            }

            public EndpointsEncoder putHost(DirectBuffer src, int srcOffset, int length) {
                if (length > 65534) {
                    throw new IllegalArgumentException("length > max value for type: " + length);
                }
                int headerLength = 2;
                int limit = this.parentMessage.limit();
                this.parentMessage.limit(limit + 2 + length);
                this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
                this.buffer.putBytes(limit + 2, src, srcOffset, length);
                return this;
            }

            public EndpointsEncoder putHost(byte[] src, int srcOffset, int length) {
                if (length > 65534) {
                    throw new IllegalArgumentException("length > max value for type: " + length);
                }
                int headerLength = 2;
                int limit = this.parentMessage.limit();
                this.parentMessage.limit(limit + 2 + length);
                this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
                this.buffer.putBytes(limit + 2, src, srcOffset, length);
                return this;
            }

            public EndpointsEncoder host(String value) {
                byte[] bytes;
                try {
                    bytes = value.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException(ex);
                }
                int length = bytes.length;
                if (length > 65534) {
                    throw new IllegalArgumentException("length > max value for type: " + length);
                }
                int headerLength = 2;
                int limit = this.parentMessage.limit();
                this.parentMessage.limit(limit + 2 + length);
                this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
                this.buffer.putBytes(limit + 2, bytes, 0, length);
                return this;
            }
        }
    }
}

