/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.clustering.gossip;

import io.zeebe.clustering.gossip.EndpointType;
import io.zeebe.clustering.gossip.GroupSizeEncodingDecoder;
import io.zeebe.clustering.gossip.MetaAttribute;
import io.zeebe.clustering.gossip.PeerState;
import io.zeebe.clustering.gossip.RaftMembershipState;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public class PeerDescriptorDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 19;
    public static final int TEMPLATE_ID = 100;
    public static final int SCHEMA_ID = 3;
    public static final int SCHEMA_VERSION = 1;
    private final PeerDescriptorDecoder parentMessage = this;
    private DirectBuffer buffer;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;
    private final EndpointsDecoder endpoints = new EndpointsDecoder();
    private final RaftMembershipsDecoder raftMemberships = new RaftMembershipsDecoder();

    public int sbeBlockLength() {
        return 19;
    }

    public int sbeTemplateId() {
        return 100;
    }

    public int sbeSchemaId() {
        return 3;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public PeerDescriptorDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        this.buffer = buffer;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int stateId() {
        return 1;
    }

    public static int stateSinceVersion() {
        return 0;
    }

    public static int stateEncodingOffset() {
        return 0;
    }

    public static int stateEncodingLength() {
        return 1;
    }

    public static String stateMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public PeerState state() {
        return PeerState.get((short)(this.buffer.getByte(this.offset + 0) & 0xFF));
    }

    public static int generationId() {
        return 2;
    }

    public static int generationSinceVersion() {
        return 0;
    }

    public static int generationEncodingOffset() {
        return 1;
    }

    public static int generationEncodingLength() {
        return 8;
    }

    public static String generationMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static long generationNullValue() {
        return -1L;
    }

    public static long generationMinValue() {
        return 0L;
    }

    public static long generationMaxValue() {
        return -2L;
    }

    public long generation() {
        return this.buffer.getLong(this.offset + 1, ByteOrder.LITTLE_ENDIAN);
    }

    public static int versionId() {
        return 3;
    }

    public static int versionSinceVersion() {
        return 0;
    }

    public static int versionEncodingOffset() {
        return 9;
    }

    public static int versionEncodingLength() {
        return 2;
    }

    public static String versionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int versionNullValue() {
        return 65535;
    }

    public static int versionMinValue() {
        return 0;
    }

    public static int versionMaxValue() {
        return 65534;
    }

    public int version() {
        return this.buffer.getShort(this.offset + 9, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public static int changeStateTimeId() {
        return 4;
    }

    public static int changeStateTimeSinceVersion() {
        return 0;
    }

    public static int changeStateTimeEncodingOffset() {
        return 11;
    }

    public static int changeStateTimeEncodingLength() {
        return 8;
    }

    public static String changeStateTimeMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static long changeStateTimeNullValue() {
        return -1L;
    }

    public static long changeStateTimeMinValue() {
        return 0L;
    }

    public static long changeStateTimeMaxValue() {
        return -2L;
    }

    public long changeStateTime() {
        return this.buffer.getLong(this.offset + 11, ByteOrder.LITTLE_ENDIAN);
    }

    public static long endpointsDecoderId() {
        return 5L;
    }

    public static int endpointsDecoderSinceVersion() {
        return 0;
    }

    public EndpointsDecoder endpoints() {
        this.endpoints.wrap(this.parentMessage, this.buffer);
        return this.endpoints;
    }

    public static long raftMembershipsDecoderId() {
        return 9L;
    }

    public static int raftMembershipsDecoderSinceVersion() {
        return 0;
    }

    public RaftMembershipsDecoder raftMemberships() {
        this.raftMemberships.wrap(this.parentMessage, this.buffer);
        return this.raftMemberships;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[PeerDescriptor](sbeTemplateId=");
        builder.append(100);
        builder.append("|sbeSchemaId=");
        builder.append(3);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 1) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(1);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 19) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(19);
        builder.append("):");
        builder.append("state=");
        builder.append((Object)this.state());
        builder.append('|');
        builder.append("generation=");
        builder.append(this.generation());
        builder.append('|');
        builder.append("version=");
        builder.append(this.version());
        builder.append('|');
        builder.append("changeStateTime=");
        builder.append(this.changeStateTime());
        builder.append('|');
        builder.append("endpoints=[");
        EndpointsDecoder endpoints = this.endpoints();
        if (endpoints.count() > 0) {
            while (endpoints.hasNext()) {
                endpoints.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        builder.append('|');
        builder.append("raftMemberships=[");
        RaftMembershipsDecoder raftMemberships = this.raftMemberships();
        if (raftMemberships.count() > 0) {
            while (raftMemberships.hasNext()) {
                raftMemberships.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        this.limit(originalLimit);
        return builder;
    }

    public static class RaftMembershipsDecoder
    implements Iterable<RaftMembershipsDecoder>,
    Iterator<RaftMembershipsDecoder> {
        private static final int HEADER_SIZE = 3;
        private final GroupSizeEncodingDecoder dimensions = new GroupSizeEncodingDecoder();
        private PeerDescriptorDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        public void wrap(PeerDescriptorDecoder parentMessage, DirectBuffer buffer) {
            this.parentMessage = parentMessage;
            this.buffer = buffer;
            this.dimensions.wrap(buffer, parentMessage.limit());
            this.blockLength = this.dimensions.blockLength();
            this.count = this.dimensions.numInGroup();
            this.index = -1;
            parentMessage.limit(parentMessage.limit() + 3);
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 5;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<RaftMembershipsDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < this.count;
        }

        @Override
        public RaftMembershipsDecoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static int partitionIdId() {
            return 10;
        }

        public static int partitionIdSinceVersion() {
            return 0;
        }

        public static int partitionIdEncodingOffset() {
            return 0;
        }

        public static int partitionIdEncodingLength() {
            return 2;
        }

        public static String partitionIdMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static int partitionIdNullValue() {
            return 65535;
        }

        public static int partitionIdMinValue() {
            return 0;
        }

        public static int partitionIdMaxValue() {
            return 65534;
        }

        public int partitionId() {
            return this.buffer.getShort(this.offset + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        }

        public static int termId() {
            return 11;
        }

        public static int termSinceVersion() {
            return 0;
        }

        public static int termEncodingOffset() {
            return 2;
        }

        public static int termEncodingLength() {
            return 2;
        }

        public static String termMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static int termNullValue() {
            return 65535;
        }

        public static int termMinValue() {
            return 0;
        }

        public static int termMaxValue() {
            return 65534;
        }

        public int term() {
            return this.buffer.getShort(this.offset + 2, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        }

        public static int stateId() {
            return 12;
        }

        public static int stateSinceVersion() {
            return 0;
        }

        public static int stateEncodingOffset() {
            return 4;
        }

        public static int stateEncodingLength() {
            return 1;
        }

        public static String stateMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public RaftMembershipState state() {
            return RaftMembershipState.get((short)(this.buffer.getByte(this.offset + 4) & 0xFF));
        }

        public static int topicNameId() {
            return 13;
        }

        public static int topicNameSinceVersion() {
            return 0;
        }

        public static String topicNameCharacterEncoding() {
            return "UTF-8";
        }

        public static String topicNameMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static int topicNameHeaderLength() {
            return 2;
        }

        public int topicNameLength() {
            int limit = this.parentMessage.limit();
            return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        }

        public int getTopicName(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 2 + dataLength);
            this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getTopicName(byte[] dst, int dstOffset, int length) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 2 + dataLength);
            this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public String topicName() {
            String value;
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.parentMessage.limit(limit + 2 + dataLength);
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
            try {
                value = new String(tmp, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public String toString() {
            return this.appendTo(new StringBuilder(100)).toString();
        }

        public StringBuilder appendTo(StringBuilder builder) {
            builder.append('(');
            builder.append("partitionId=");
            builder.append(this.partitionId());
            builder.append('|');
            builder.append("term=");
            builder.append(this.term());
            builder.append('|');
            builder.append("state=");
            builder.append((Object)this.state());
            builder.append('|');
            builder.append("topicName=");
            builder.append(this.topicName());
            builder.append(')');
            return builder;
        }
    }

    public static class EndpointsDecoder
    implements Iterable<EndpointsDecoder>,
    Iterator<EndpointsDecoder> {
        private static final int HEADER_SIZE = 3;
        private final GroupSizeEncodingDecoder dimensions = new GroupSizeEncodingDecoder();
        private PeerDescriptorDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        public void wrap(PeerDescriptorDecoder parentMessage, DirectBuffer buffer) {
            this.parentMessage = parentMessage;
            this.buffer = buffer;
            this.dimensions.wrap(buffer, parentMessage.limit());
            this.blockLength = this.dimensions.blockLength();
            this.count = this.dimensions.numInGroup();
            this.index = -1;
            parentMessage.limit(parentMessage.limit() + 3);
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 3;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<EndpointsDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < this.count;
        }

        @Override
        public EndpointsDecoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static int endpointTypeId() {
            return 6;
        }

        public static int endpointTypeSinceVersion() {
            return 0;
        }

        public static int endpointTypeEncodingOffset() {
            return 0;
        }

        public static int endpointTypeEncodingLength() {
            return 1;
        }

        public static String endpointTypeMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public EndpointType endpointType() {
            return EndpointType.get((short)(this.buffer.getByte(this.offset + 0) & 0xFF));
        }

        public static int portId() {
            return 7;
        }

        public static int portSinceVersion() {
            return 0;
        }

        public static int portEncodingOffset() {
            return 1;
        }

        public static int portEncodingLength() {
            return 2;
        }

        public static String portMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static int portNullValue() {
            return 65535;
        }

        public static int portMinValue() {
            return 0;
        }

        public static int portMaxValue() {
            return 65534;
        }

        public int port() {
            return this.buffer.getShort(this.offset + 1, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        }

        public static int hostId() {
            return 8;
        }

        public static int hostSinceVersion() {
            return 0;
        }

        public static String hostCharacterEncoding() {
            return "UTF-8";
        }

        public static String hostMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static int hostHeaderLength() {
            return 2;
        }

        public int hostLength() {
            int limit = this.parentMessage.limit();
            return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        }

        public int getHost(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 2 + dataLength);
            this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getHost(byte[] dst, int dstOffset, int length) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 2 + dataLength);
            this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public String host() {
            String value;
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.parentMessage.limit(limit + 2 + dataLength);
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
            try {
                value = new String(tmp, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public String toString() {
            return this.appendTo(new StringBuilder(100)).toString();
        }

        public StringBuilder appendTo(StringBuilder builder) {
            builder.append('(');
            builder.append("endpointType=");
            builder.append((Object)this.endpointType());
            builder.append('|');
            builder.append("port=");
            builder.append(this.port());
            builder.append('|');
            builder.append("host=");
            builder.append(this.host());
            builder.append(')');
            return builder;
        }
    }
}

