/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.clustering.gossip;

import io.zeebe.clustering.gossip.MetaAttribute;
import io.zeebe.clustering.gossip.ProbeDecoder;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;

public class ProbeEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 2;
    public static final int TEMPLATE_ID = 1;
    public static final int SCHEMA_ID = 3;
    public static final int SCHEMA_VERSION = 1;
    private final ProbeEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;

    public int sbeBlockLength() {
        return 2;
    }

    public int sbeTemplateId() {
        return 1;
    }

    public int sbeSchemaId() {
        return 3;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public ProbeEncoder wrap(MutableDirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        this.limit(offset + 2);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int portEncodingOffset() {
        return 0;
    }

    public static int portEncodingLength() {
        return 2;
    }

    public static int portNullValue() {
        return 65535;
    }

    public static int portMinValue() {
        return 0;
    }

    public static int portMaxValue() {
        return 65534;
    }

    public ProbeEncoder port(int value) {
        this.buffer.putShort(this.offset + 0, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int hostId() {
        return 2;
    }

    public static String hostCharacterEncoding() {
        return "UTF-8";
    }

    public static String hostMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int hostHeaderLength() {
        return 2;
    }

    public ProbeEncoder putHost(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public ProbeEncoder putHost(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public ProbeEncoder host(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        ProbeDecoder writer = new ProbeDecoder();
        writer.wrap((DirectBuffer)this.buffer, this.offset, 2, 1);
        return writer.appendTo(builder);
    }
}

