/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.clustering.management;

import io.zeebe.clustering.management.GroupSizeEncodingDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.CompositeEncoderFlyweight;

public class GroupSizeEncodingEncoder
implements CompositeEncoderFlyweight {
    public static final int ENCODED_LENGTH = 3;
    private int offset;
    private MutableDirectBuffer buffer;

    public GroupSizeEncodingEncoder wrap(MutableDirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        return this;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int encodedLength() {
        return 3;
    }

    public static int blockLengthEncodingOffset() {
        return 0;
    }

    public static int blockLengthEncodingLength() {
        return 2;
    }

    public static int blockLengthNullValue() {
        return 65535;
    }

    public static int blockLengthMinValue() {
        return 0;
    }

    public static int blockLengthMaxValue() {
        return 65534;
    }

    public GroupSizeEncodingEncoder blockLength(int value) {
        this.buffer.putShort(this.offset + 0, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int numInGroupEncodingOffset() {
        return 2;
    }

    public static int numInGroupEncodingLength() {
        return 1;
    }

    public static short numInGroupNullValue() {
        return 255;
    }

    public static short numInGroupMinValue() {
        return 0;
    }

    public static short numInGroupMaxValue() {
        return 254;
    }

    public GroupSizeEncodingEncoder numInGroup(short value) {
        this.buffer.putByte(this.offset + 2, (byte)value);
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        GroupSizeEncodingDecoder writer = new GroupSizeEncodingDecoder();
        writer.wrap((DirectBuffer)this.buffer, this.offset);
        return writer.appendTo(builder);
    }
}

