/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.clustering.management;

import io.zeebe.clustering.management.GroupSizeEncodingEncoder;
import io.zeebe.clustering.management.InvitationRequestDecoder;
import io.zeebe.clustering.management.MetaAttribute;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;

public class InvitationRequestEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 6;
    public static final int TEMPLATE_ID = 0;
    public static final int SCHEMA_ID = 5;
    public static final int SCHEMA_VERSION = 1;
    private final InvitationRequestEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;
    private final MembersEncoder members = new MembersEncoder();

    public int sbeBlockLength() {
        return 6;
    }

    public int sbeTemplateId() {
        return 0;
    }

    public int sbeSchemaId() {
        return 5;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public InvitationRequestEncoder wrap(MutableDirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        this.limit(offset + 6);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int partitionIdEncodingOffset() {
        return 0;
    }

    public static int partitionIdEncodingLength() {
        return 2;
    }

    public static int partitionIdNullValue() {
        return 65535;
    }

    public static int partitionIdMinValue() {
        return 0;
    }

    public static int partitionIdMaxValue() {
        return 65534;
    }

    public InvitationRequestEncoder partitionId(int value) {
        this.buffer.putShort(this.offset + 0, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int termEncodingOffset() {
        return 2;
    }

    public static int termEncodingLength() {
        return 2;
    }

    public static int termNullValue() {
        return 65535;
    }

    public static int termMinValue() {
        return 0;
    }

    public static int termMaxValue() {
        return 65534;
    }

    public InvitationRequestEncoder term(int value) {
        this.buffer.putShort(this.offset + 2, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int nameEncodingOffset() {
        return 4;
    }

    public static int nameEncodingLength() {
        return 2;
    }

    public static int nameNullValue() {
        return 65535;
    }

    public static int nameMinValue() {
        return 0;
    }

    public static int nameMaxValue() {
        return 65534;
    }

    public InvitationRequestEncoder name(int value) {
        this.buffer.putShort(this.offset + 4, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static long membersId() {
        return 3L;
    }

    public MembersEncoder membersCount(int count) {
        this.members.wrap(this.parentMessage, this.buffer, count);
        return this.members;
    }

    public static int topicNameId() {
        return 6;
    }

    public static String topicNameCharacterEncoding() {
        return "UTF-8";
    }

    public static String topicNameMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int topicNameHeaderLength() {
        return 2;
    }

    public InvitationRequestEncoder putTopicName(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public InvitationRequestEncoder putTopicName(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public InvitationRequestEncoder topicName(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        InvitationRequestDecoder writer = new InvitationRequestDecoder();
        writer.wrap((DirectBuffer)this.buffer, this.offset, 6, 1);
        return writer.appendTo(builder);
    }

    public static class MembersEncoder {
        private static final int HEADER_SIZE = 3;
        private final GroupSizeEncodingEncoder dimensions = new GroupSizeEncodingEncoder();
        private InvitationRequestEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;

        public void wrap(InvitationRequestEncoder parentMessage, MutableDirectBuffer buffer, int count) {
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            this.parentMessage = parentMessage;
            this.buffer = buffer;
            this.dimensions.wrap(buffer, parentMessage.limit());
            this.dimensions.blockLength(2);
            this.dimensions.numInGroup((short)count);
            this.index = -1;
            this.count = count;
            parentMessage.limit(parentMessage.limit() + 3);
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 2;
        }

        public MembersEncoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + MembersEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public static int portEncodingOffset() {
            return 0;
        }

        public static int portEncodingLength() {
            return 2;
        }

        public static int portNullValue() {
            return 65535;
        }

        public static int portMinValue() {
            return 0;
        }

        public static int portMaxValue() {
            return 65534;
        }

        public MembersEncoder port(int value) {
            this.buffer.putShort(this.offset + 0, (short)value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int hostId() {
            return 5;
        }

        public static String hostCharacterEncoding() {
            return "UTF-8";
        }

        public static String hostMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static int hostHeaderLength() {
            return 2;
        }

        public MembersEncoder putHost(DirectBuffer src, int srcOffset, int length) {
            if (length > 65534) {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 2 + length);
            this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 2, src, srcOffset, length);
            return this;
        }

        public MembersEncoder putHost(byte[] src, int srcOffset, int length) {
            if (length > 65534) {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 2 + length);
            this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 2, src, srcOffset, length);
            return this;
        }

        public MembersEncoder host(String value) {
            byte[] bytes;
            try {
                bytes = value.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            int length = bytes.length;
            if (length > 65534) {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 2 + length);
            this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 2, bytes, 0, length);
            return this;
        }
    }
}

