/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.clustering.raft;

import io.zeebe.clustering.raft.AppendResponseDecoder;
import io.zeebe.clustering.raft.BooleanType;
import io.zeebe.clustering.raft.MetaAttribute;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;

public class AppendResponseEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 15;
    public static final int TEMPLATE_ID = 11;
    public static final int SCHEMA_ID = 4;
    public static final int SCHEMA_VERSION = 1;
    private final AppendResponseEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;

    public int sbeBlockLength() {
        return 15;
    }

    public int sbeTemplateId() {
        return 11;
    }

    public int sbeSchemaId() {
        return 4;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public AppendResponseEncoder wrap(MutableDirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        this.limit(offset + 15);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int partitionIdEncodingOffset() {
        return 0;
    }

    public static int partitionIdEncodingLength() {
        return 2;
    }

    public static int partitionIdNullValue() {
        return 65535;
    }

    public static int partitionIdMinValue() {
        return 0;
    }

    public static int partitionIdMaxValue() {
        return 65534;
    }

    public AppendResponseEncoder partitionId(int value) {
        this.buffer.putShort(this.offset + 0, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int termEncodingOffset() {
        return 2;
    }

    public static int termEncodingLength() {
        return 2;
    }

    public static int termNullValue() {
        return 65535;
    }

    public static int termMinValue() {
        return 0;
    }

    public static int termMaxValue() {
        return 65534;
    }

    public AppendResponseEncoder term(int value) {
        this.buffer.putShort(this.offset + 2, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int succeededEncodingOffset() {
        return 4;
    }

    public static int succeededEncodingLength() {
        return 1;
    }

    public AppendResponseEncoder succeeded(BooleanType value) {
        this.buffer.putByte(this.offset + 4, (byte)value.value());
        return this;
    }

    public static int entryPositionEncodingOffset() {
        return 5;
    }

    public static int entryPositionEncodingLength() {
        return 8;
    }

    public static long entryPositionNullValue() {
        return -1L;
    }

    public static long entryPositionMinValue() {
        return 0L;
    }

    public static long entryPositionMaxValue() {
        return -2L;
    }

    public AppendResponseEncoder entryPosition(long value) {
        this.buffer.putLong(this.offset + 5, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int portEncodingOffset() {
        return 13;
    }

    public static int portEncodingLength() {
        return 2;
    }

    public static int portNullValue() {
        return 65535;
    }

    public static int portMinValue() {
        return 0;
    }

    public static int portMaxValue() {
        return 65534;
    }

    public AppendResponseEncoder port(int value) {
        this.buffer.putShort(this.offset + 13, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int topicNameId() {
        return 5;
    }

    public static String topicNameCharacterEncoding() {
        return "UTF-8";
    }

    public static String topicNameMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int topicNameHeaderLength() {
        return 2;
    }

    public AppendResponseEncoder putTopicName(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public AppendResponseEncoder putTopicName(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public AppendResponseEncoder topicName(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int hostId() {
        return 6;
    }

    public static String hostCharacterEncoding() {
        return "UTF-8";
    }

    public static String hostMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int hostHeaderLength() {
        return 2;
    }

    public AppendResponseEncoder putHost(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public AppendResponseEncoder putHost(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public AppendResponseEncoder host(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        AppendResponseDecoder writer = new AppendResponseDecoder();
        writer.wrap((DirectBuffer)this.buffer, this.offset, 15, 1);
        return writer.appendTo(builder);
    }
}

