/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.clustering.raft;

import io.zeebe.clustering.raft.GroupSizeEncodingDecoder;
import io.zeebe.clustering.raft.MetaAttribute;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public class ConfigureRequestDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 16;
    public static final int TEMPLATE_ID = 4;
    public static final int SCHEMA_ID = 4;
    public static final int SCHEMA_VERSION = 1;
    private final ConfigureRequestDecoder parentMessage = this;
    private DirectBuffer buffer;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;
    private final MembersDecoder members = new MembersDecoder();

    public int sbeBlockLength() {
        return 16;
    }

    public int sbeTemplateId() {
        return 4;
    }

    public int sbeSchemaId() {
        return 4;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public ConfigureRequestDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        this.buffer = buffer;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int partitionIdId() {
        return 0;
    }

    public static int partitionIdSinceVersion() {
        return 0;
    }

    public static int partitionIdEncodingOffset() {
        return 0;
    }

    public static int partitionIdEncodingLength() {
        return 2;
    }

    public static String partitionIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int partitionIdNullValue() {
        return 65535;
    }

    public static int partitionIdMinValue() {
        return 0;
    }

    public static int partitionIdMaxValue() {
        return 65534;
    }

    public int partitionId() {
        return this.buffer.getShort(this.offset + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public static int termId() {
        return 1;
    }

    public static int termSinceVersion() {
        return 0;
    }

    public static int termEncodingOffset() {
        return 2;
    }

    public static int termEncodingLength() {
        return 2;
    }

    public static String termMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int termNullValue() {
        return 65535;
    }

    public static int termMinValue() {
        return 0;
    }

    public static int termMaxValue() {
        return 65534;
    }

    public int term() {
        return this.buffer.getShort(this.offset + 2, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public static int configurationEntryPositionId() {
        return 2;
    }

    public static int configurationEntryPositionSinceVersion() {
        return 0;
    }

    public static int configurationEntryPositionEncodingOffset() {
        return 4;
    }

    public static int configurationEntryPositionEncodingLength() {
        return 8;
    }

    public static String configurationEntryPositionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static long configurationEntryPositionNullValue() {
        return -1L;
    }

    public static long configurationEntryPositionMinValue() {
        return 0L;
    }

    public static long configurationEntryPositionMaxValue() {
        return -2L;
    }

    public long configurationEntryPosition() {
        return this.buffer.getLong(this.offset + 4, ByteOrder.LITTLE_ENDIAN);
    }

    public static int configurationEntryTermId() {
        return 3;
    }

    public static int configurationEntryTermSinceVersion() {
        return 0;
    }

    public static int configurationEntryTermEncodingOffset() {
        return 12;
    }

    public static int configurationEntryTermEncodingLength() {
        return 4;
    }

    public static String configurationEntryTermMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int configurationEntryTermNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int configurationEntryTermMinValue() {
        return -2147483647;
    }

    public static int configurationEntryTermMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int configurationEntryTerm() {
        return this.buffer.getInt(this.offset + 12, ByteOrder.LITTLE_ENDIAN);
    }

    public static long membersDecoderId() {
        return 4L;
    }

    public static int membersDecoderSinceVersion() {
        return 0;
    }

    public MembersDecoder members() {
        this.members.wrap(this.parentMessage, this.buffer);
        return this.members;
    }

    public static int topicNameId() {
        return 7;
    }

    public static int topicNameSinceVersion() {
        return 0;
    }

    public static String topicNameCharacterEncoding() {
        return "UTF-8";
    }

    public static String topicNameMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int topicNameHeaderLength() {
        return 2;
    }

    public int topicNameLength() {
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public int getTopicName(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getTopicName(byte[] dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public String topicName() {
        String value;
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[ConfigureRequest](sbeTemplateId=");
        builder.append(4);
        builder.append("|sbeSchemaId=");
        builder.append(4);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 1) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(1);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 16) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(16);
        builder.append("):");
        builder.append("partitionId=");
        builder.append(this.partitionId());
        builder.append('|');
        builder.append("term=");
        builder.append(this.term());
        builder.append('|');
        builder.append("configurationEntryPosition=");
        builder.append(this.configurationEntryPosition());
        builder.append('|');
        builder.append("configurationEntryTerm=");
        builder.append(this.configurationEntryTerm());
        builder.append('|');
        builder.append("members=[");
        MembersDecoder members = this.members();
        if (members.count() > 0) {
            while (members.hasNext()) {
                members.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        builder.append('|');
        builder.append("topicName=");
        builder.append(this.topicName());
        this.limit(originalLimit);
        return builder;
    }

    public static class MembersDecoder
    implements Iterable<MembersDecoder>,
    Iterator<MembersDecoder> {
        private static final int HEADER_SIZE = 3;
        private final GroupSizeEncodingDecoder dimensions = new GroupSizeEncodingDecoder();
        private ConfigureRequestDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        public void wrap(ConfigureRequestDecoder parentMessage, DirectBuffer buffer) {
            this.parentMessage = parentMessage;
            this.buffer = buffer;
            this.dimensions.wrap(buffer, parentMessage.limit());
            this.blockLength = this.dimensions.blockLength();
            this.count = this.dimensions.numInGroup();
            this.index = -1;
            parentMessage.limit(parentMessage.limit() + 3);
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 2;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<MembersDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < this.count;
        }

        @Override
        public MembersDecoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static int portId() {
            return 5;
        }

        public static int portSinceVersion() {
            return 0;
        }

        public static int portEncodingOffset() {
            return 0;
        }

        public static int portEncodingLength() {
            return 2;
        }

        public static String portMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static int portNullValue() {
            return 65535;
        }

        public static int portMinValue() {
            return 0;
        }

        public static int portMaxValue() {
            return 65534;
        }

        public int port() {
            return this.buffer.getShort(this.offset + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        }

        public static int hostId() {
            return 6;
        }

        public static int hostSinceVersion() {
            return 0;
        }

        public static String hostCharacterEncoding() {
            return "UTF-8";
        }

        public static String hostMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static int hostHeaderLength() {
            return 2;
        }

        public int hostLength() {
            int limit = this.parentMessage.limit();
            return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        }

        public int getHost(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 2 + dataLength);
            this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getHost(byte[] dst, int dstOffset, int length) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 2 + dataLength);
            this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public String host() {
            String value;
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.parentMessage.limit(limit + 2 + dataLength);
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
            try {
                value = new String(tmp, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public String toString() {
            return this.appendTo(new StringBuilder(100)).toString();
        }

        public StringBuilder appendTo(StringBuilder builder) {
            builder.append('(');
            builder.append("port=");
            builder.append(this.port());
            builder.append('|');
            builder.append("host=");
            builder.append(this.host());
            builder.append(')');
            return builder;
        }
    }
}

