/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.clustering.raft;

import io.zeebe.clustering.raft.BooleanType;
import io.zeebe.clustering.raft.VoteResponseDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;

public class VoteResponseEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 3;
    public static final int TEMPLATE_ID = 9;
    public static final int SCHEMA_ID = 4;
    public static final int SCHEMA_VERSION = 1;
    private final VoteResponseEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;

    public int sbeBlockLength() {
        return 3;
    }

    public int sbeTemplateId() {
        return 9;
    }

    public int sbeSchemaId() {
        return 4;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public VoteResponseEncoder wrap(MutableDirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        this.limit(offset + 3);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int termEncodingOffset() {
        return 0;
    }

    public static int termEncodingLength() {
        return 2;
    }

    public static int termNullValue() {
        return 65535;
    }

    public static int termMinValue() {
        return 0;
    }

    public static int termMaxValue() {
        return 65534;
    }

    public VoteResponseEncoder term(int value) {
        this.buffer.putShort(this.offset + 0, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int grantedEncodingOffset() {
        return 2;
    }

    public static int grantedEncodingLength() {
        return 1;
    }

    public VoteResponseEncoder granted(BooleanType value) {
        this.buffer.putByte(this.offset + 2, (byte)value.value());
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        VoteResponseDecoder writer = new VoteResponseDecoder();
        writer.wrap((DirectBuffer)this.buffer, this.offset, 3, 1);
        return writer.appendTo(builder);
    }
}

