/*
 * Zeebe Broker Core
 * Copyright © 2017 camunda services GmbH (info@camunda.com)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package io.zeebe.broker.event;

import io.zeebe.broker.event.processor.TopicSubscriptionService;
import io.zeebe.logstreams.processor.StreamProcessorController;
import io.zeebe.servicecontainer.ServiceName;

public class TopicSubscriptionServiceNames
{

    public static final ServiceName<TopicSubscriptionService> TOPIC_SUBSCRIPTION_SERVICE = ServiceName.newServiceName("log.subscription.manager", TopicSubscriptionService.class);

    public static ServiceName<StreamProcessorController> subscriptionPushServiceName(String logStreamName, String subscriptionName)
    {
        return ServiceName.newServiceName(String.format("log.%s.subscription.push.%s", logStreamName, subscriptionName), StreamProcessorController.class);
    }

    public static ServiceName<StreamProcessorController> subscriptionManagementServiceName(String logStreamName)
    {
        return ServiceName.newServiceName(String.format("log.%s.subscription.management", logStreamName), StreamProcessorController.class);
    }
}
