/* Generated SBE (Simple Binary Encoding) message codec */
package io.zeebe.clustering.raft;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;
import org.agrona.sbe.*;

@javax.annotation.Generated(value = {"io.zeebe.clustering.raft.JoinResponseEncoder"})
@SuppressWarnings("all")
public class JoinResponseEncoder implements MessageEncoderFlyweight
{
    public static final int BLOCK_LENGTH = 15;
    public static final int TEMPLATE_ID = 1;
    public static final int SCHEMA_ID = 4;
    public static final int SCHEMA_VERSION = 1;

    private final JoinResponseEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public JoinResponseEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        this.buffer = buffer;
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int termEncodingOffset()
    {
        return 0;
    }

    public static int termEncodingLength()
    {
        return 2;
    }

    public static int termNullValue()
    {
        return 65535;
    }

    public static int termMinValue()
    {
        return 0;
    }

    public static int termMaxValue()
    {
        return 65534;
    }

    public JoinResponseEncoder term(final int value)
    {
        buffer.putShort(offset + 0, (short)value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int succeededEncodingOffset()
    {
        return 2;
    }

    public static int succeededEncodingLength()
    {
        return 1;
    }

    public JoinResponseEncoder succeeded(final BooleanType value)
    {
        buffer.putByte(offset + 2, (byte)value.value());
        return this;
    }

    public static int configurationEntryPositionEncodingOffset()
    {
        return 3;
    }

    public static int configurationEntryPositionEncodingLength()
    {
        return 8;
    }

    public static long configurationEntryPositionNullValue()
    {
        return 0xffffffffffffffffL;
    }

    public static long configurationEntryPositionMinValue()
    {
        return 0x0L;
    }

    public static long configurationEntryPositionMaxValue()
    {
        return 0xfffffffffffffffeL;
    }

    public JoinResponseEncoder configurationEntryPosition(final long value)
    {
        buffer.putLong(offset + 3, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int configurationEntryTermEncodingOffset()
    {
        return 11;
    }

    public static int configurationEntryTermEncodingLength()
    {
        return 4;
    }

    public static int configurationEntryTermNullValue()
    {
        return -2147483648;
    }

    public static int configurationEntryTermMinValue()
    {
        return -2147483647;
    }

    public static int configurationEntryTermMaxValue()
    {
        return 2147483647;
    }

    public JoinResponseEncoder configurationEntryTerm(final int value)
    {
        buffer.putInt(offset + 11, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    private final MembersEncoder members = new MembersEncoder();

    public static long membersId()
    {
        return 6;
    }

    public MembersEncoder membersCount(final int count)
    {
        members.wrap(parentMessage, buffer, count);
        return members;
    }

    public static class MembersEncoder
    {
        private static final int HEADER_SIZE = 3;
        private final GroupSizeEncodingEncoder dimensions = new GroupSizeEncodingEncoder();
        private JoinResponseEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;

        public void wrap(
            final JoinResponseEncoder parentMessage, final MutableDirectBuffer buffer, final int count)
        {
            if (count < 0 || count > 254)
            {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }

            this.parentMessage = parentMessage;
            this.buffer = buffer;
            dimensions.wrap(buffer, parentMessage.limit());
            dimensions.blockLength((int)2);
            dimensions.numInGroup((short)count);
            index = -1;
            this.count = count;
            parentMessage.limit(parentMessage.limit() + HEADER_SIZE);
        }

        public static int sbeHeaderSize()
        {
            return HEADER_SIZE;
        }

        public static int sbeBlockLength()
        {
            return 2;
        }

        public MembersEncoder next()
        {
            if (index + 1 >= count)
            {
                throw new java.util.NoSuchElementException();
            }

            offset = parentMessage.limit();
            parentMessage.limit(offset + sbeBlockLength());
            ++index;

            return this;
        }

        public static int portEncodingOffset()
        {
            return 0;
        }

        public static int portEncodingLength()
        {
            return 2;
        }

        public static int portNullValue()
        {
            return 65535;
        }

        public static int portMinValue()
        {
            return 0;
        }

        public static int portMaxValue()
        {
            return 65534;
        }

        public MembersEncoder port(final int value)
        {
            buffer.putShort(offset + 0, (short)value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }


        public static int hostId()
        {
            return 8;
        }

        public static String hostCharacterEncoding()
        {
            return "UTF-8";
        }

        public static String hostMetaAttribute(final MetaAttribute metaAttribute)
        {
            switch (metaAttribute)
            {
                case EPOCH: return "unix";
                case TIME_UNIT: return "nanosecond";
                case SEMANTIC_TYPE: return "";
            }

            return "";
        }

        public static int hostHeaderLength()
        {
            return 2;
        }

        public MembersEncoder putHost(final DirectBuffer src, final int srcOffset, final int length)
        {
            if (length > 65534)
            {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }

            final int headerLength = 2;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putShort(limit, (short)length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public MembersEncoder putHost(final byte[] src, final int srcOffset, final int length)
        {
            if (length > 65534)
            {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }

            final int headerLength = 2;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putShort(limit, (short)length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public MembersEncoder host(final String value)
        {
            final byte[] bytes;
            try
            {
                bytes = value.getBytes("UTF-8");
            }
            catch (final java.io.UnsupportedEncodingException ex)
            {
                throw new RuntimeException(ex);
            }

            final int length = bytes.length;
            if (length > 65534)
            {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }

            final int headerLength = 2;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putShort(limit, (short)length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, bytes, 0, length);

            return this;
        }
    }


    public String toString()
    {
        return appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        JoinResponseDecoder writer = new JoinResponseDecoder();
        writer.wrap(buffer, offset, BLOCK_LENGTH, SCHEMA_VERSION);

        return writer.appendTo(builder);
    }
}
