/* Generated SBE (Simple Binary Encoding) message codec */
package io.zeebe.clustering.raft;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;
import org.agrona.sbe.*;

@javax.annotation.Generated(value = {"io.zeebe.clustering.raft.PollRequestEncoder"})
@SuppressWarnings("all")
public class PollRequestEncoder implements MessageEncoderFlyweight
{
    public static final int BLOCK_LENGTH = 18;
    public static final int TEMPLATE_ID = 6;
    public static final int SCHEMA_ID = 4;
    public static final int SCHEMA_VERSION = 1;

    private final PollRequestEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public PollRequestEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        this.buffer = buffer;
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int partitionIdEncodingOffset()
    {
        return 0;
    }

    public static int partitionIdEncodingLength()
    {
        return 2;
    }

    public static int partitionIdNullValue()
    {
        return 65535;
    }

    public static int partitionIdMinValue()
    {
        return 0;
    }

    public static int partitionIdMaxValue()
    {
        return 65534;
    }

    public PollRequestEncoder partitionId(final int value)
    {
        buffer.putShort(offset + 0, (short)value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int termEncodingOffset()
    {
        return 2;
    }

    public static int termEncodingLength()
    {
        return 2;
    }

    public static int termNullValue()
    {
        return 65535;
    }

    public static int termMinValue()
    {
        return 0;
    }

    public static int termMaxValue()
    {
        return 65534;
    }

    public PollRequestEncoder term(final int value)
    {
        buffer.putShort(offset + 2, (short)value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int lastEntryPositionEncodingOffset()
    {
        return 4;
    }

    public static int lastEntryPositionEncodingLength()
    {
        return 8;
    }

    public static long lastEntryPositionNullValue()
    {
        return 0xffffffffffffffffL;
    }

    public static long lastEntryPositionMinValue()
    {
        return 0x0L;
    }

    public static long lastEntryPositionMaxValue()
    {
        return 0xfffffffffffffffeL;
    }

    public PollRequestEncoder lastEntryPosition(final long value)
    {
        buffer.putLong(offset + 4, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int lastEntryTermEncodingOffset()
    {
        return 12;
    }

    public static int lastEntryTermEncodingLength()
    {
        return 4;
    }

    public static int lastEntryTermNullValue()
    {
        return -2147483648;
    }

    public static int lastEntryTermMinValue()
    {
        return -2147483647;
    }

    public static int lastEntryTermMaxValue()
    {
        return 2147483647;
    }

    public PollRequestEncoder lastEntryTerm(final int value)
    {
        buffer.putInt(offset + 12, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int portEncodingOffset()
    {
        return 16;
    }

    public static int portEncodingLength()
    {
        return 2;
    }

    public static int portNullValue()
    {
        return 65535;
    }

    public static int portMinValue()
    {
        return 0;
    }

    public static int portMaxValue()
    {
        return 65534;
    }

    public PollRequestEncoder port(final int value)
    {
        buffer.putShort(offset + 16, (short)value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int topicNameId()
    {
        return 5;
    }

    public static String topicNameCharacterEncoding()
    {
        return "UTF-8";
    }

    public static String topicNameMetaAttribute(final MetaAttribute metaAttribute)
    {
        switch (metaAttribute)
        {
            case EPOCH: return "unix";
            case TIME_UNIT: return "nanosecond";
            case SEMANTIC_TYPE: return "";
        }

        return "";
    }

    public static int topicNameHeaderLength()
    {
        return 2;
    }

    public PollRequestEncoder putTopicName(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 65534)
        {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }

        final int headerLength = 2;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putShort(limit, (short)length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public PollRequestEncoder putTopicName(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 65534)
        {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }

        final int headerLength = 2;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putShort(limit, (short)length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public PollRequestEncoder topicName(final String value)
    {
        final byte[] bytes;
        try
        {
            bytes = value.getBytes("UTF-8");
        }
        catch (final java.io.UnsupportedEncodingException ex)
        {
            throw new RuntimeException(ex);
        }

        final int length = bytes.length;
        if (length > 65534)
        {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }

        final int headerLength = 2;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putShort(limit, (short)length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, bytes, 0, length);

        return this;
    }

    public static int hostId()
    {
        return 6;
    }

    public static String hostCharacterEncoding()
    {
        return "UTF-8";
    }

    public static String hostMetaAttribute(final MetaAttribute metaAttribute)
    {
        switch (metaAttribute)
        {
            case EPOCH: return "unix";
            case TIME_UNIT: return "nanosecond";
            case SEMANTIC_TYPE: return "";
        }

        return "";
    }

    public static int hostHeaderLength()
    {
        return 2;
    }

    public PollRequestEncoder putHost(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 65534)
        {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }

        final int headerLength = 2;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putShort(limit, (short)length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public PollRequestEncoder putHost(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 65534)
        {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }

        final int headerLength = 2;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putShort(limit, (short)length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public PollRequestEncoder host(final String value)
    {
        final byte[] bytes;
        try
        {
            bytes = value.getBytes("UTF-8");
        }
        catch (final java.io.UnsupportedEncodingException ex)
        {
            throw new RuntimeException(ex);
        }

        final int length = bytes.length;
        if (length > 65534)
        {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }

        final int headerLength = 2;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putShort(limit, (short)length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, bytes, 0, length);

        return this;
    }


    public String toString()
    {
        return appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        PollRequestDecoder writer = new PollRequestDecoder();
        writer.wrap(buffer, offset, BLOCK_LENGTH, SCHEMA_VERSION);

        return writer.appendTo(builder);
    }
}
