/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.el.impl;

import io.zeebe.el.Expression;
import java.util.Optional;
import org.camunda.feel.syntaxtree.Exp;
import org.camunda.feel.syntaxtree.ParsedExpression;
import org.camunda.feel.syntaxtree.PathExpression;
import org.camunda.feel.syntaxtree.Ref;

public final class FeelExpression
implements Expression {
    private final ParsedExpression expression;

    public FeelExpression(ParsedExpression expression) {
        this.expression = expression;
    }

    @Override
    public String getExpression() {
        return this.expression.text();
    }

    @Override
    public Optional<String> getVariableName() {
        return FeelExpression.extractVariableName(this.expression.expression());
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public String getFailureMessage() {
        return null;
    }

    private static Optional<String> extractVariableName(Exp expression) {
        if (expression instanceof PathExpression) {
            PathExpression path = (PathExpression)expression;
            return FeelExpression.extractVariableName(path.path());
        }
        if (expression instanceof Ref) {
            Ref ref = (Ref)expression;
            return Optional.of((String)ref.names().head());
        }
        return Optional.empty();
    }

    public ParsedExpression getParsedExpression() {
        return this.expression;
    }

    public String toString() {
        return "FeelExpression{expression=" + this.expression + "}";
    }
}

