/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.el.impl;

import io.zeebe.el.EvaluationContext;
import io.zeebe.el.EvaluationResult;
import io.zeebe.el.Expression;
import io.zeebe.el.ExpressionLanguage;
import io.zeebe.el.impl.EvaluationFailure;
import io.zeebe.el.impl.FeelExpression;
import io.zeebe.el.impl.InvalidExpression;
import io.zeebe.el.impl.StaticExpression;
import io.zeebe.el.impl.ZeebeFeelEngineClock;
import io.zeebe.el.impl.feel.FeelEvaluationResult;
import io.zeebe.el.impl.feel.FeelFunctionProvider;
import io.zeebe.el.impl.feel.FeelToMessagePackTransformer;
import io.zeebe.el.impl.feel.FeelVariableContext;
import io.zeebe.el.impl.feel.MessagePackValueMapper;
import io.zeebe.util.EnsureUtil;
import io.zeebe.util.sched.clock.ActorClock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.agrona.DirectBuffer;
import org.camunda.feel.FeelEngine;
import org.camunda.feel.FeelEngineClock;
import org.camunda.feel.context.Context;
import org.camunda.feel.context.FunctionProvider;
import org.camunda.feel.syntaxtree.ParsedExpression;
import org.camunda.feel.syntaxtree.Val;
import org.camunda.feel.valuemapper.CustomValueMapper;
import scala.Function1;
import scala.util.Either;

public final class FeelExpressionLanguage
implements ExpressionLanguage {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\=(.+)", 32);
    private final FeelToMessagePackTransformer messagePackTransformer = new FeelToMessagePackTransformer();
    private final FeelEngine feelEngine;

    public FeelExpressionLanguage(ActorClock clock) {
        this.feelEngine = new FeelEngine.Builder().customValueMapper((CustomValueMapper)new MessagePackValueMapper()).functionProvider((FunctionProvider)new FeelFunctionProvider()).clock((FeelEngineClock)new ZeebeFeelEngineClock(clock)).build();
    }

    @Override
    public Expression parseExpression(String expression) {
        EnsureUtil.ensureNotNull((String)"expression", (Object)expression);
        Matcher expressionMatcher = EXPRESSION_PATTERN.matcher(expression);
        if (expressionMatcher.matches()) {
            String unpackedExpression = expressionMatcher.group(1);
            return this.parseFeelExpression(unpackedExpression);
        }
        return new StaticExpression(expression);
    }

    @Override
    public EvaluationResult evaluateExpression(Expression expression, EvaluationContext context) {
        EnsureUtil.ensureNotNull((String)"expression", (Object)expression);
        EnsureUtil.ensureNotNull((String)"context", (Object)context);
        if (!expression.isValid()) {
            String failureMessage = expression.getFailureMessage();
            return new EvaluationFailure(expression, failureMessage);
        }
        if (expression instanceof StaticExpression) {
            StaticExpression staticExpression = (StaticExpression)expression;
            return staticExpression;
        }
        if (expression instanceof FeelExpression) {
            FeelExpression feelExpression = (FeelExpression)expression;
            return this.evaluateFeelExpression(expression, context, feelExpression);
        }
        throw new IllegalArgumentException(String.format("Expected FEEL expression or static value but found '%s'", expression));
    }

    private Expression parseFeelExpression(String expression) {
        Either parseResult = this.feelEngine.parseExpression(expression);
        if (parseResult.isLeft()) {
            FeelEngine.Failure failure = (FeelEngine.Failure)parseResult.left().get();
            return new InvalidExpression(expression, failure.message());
        }
        ParsedExpression parsedExpression = (ParsedExpression)parseResult.right().get();
        return new FeelExpression(parsedExpression);
    }

    private EvaluationResult evaluateFeelExpression(Expression expression, EvaluationContext context, FeelExpression feelExpression) {
        FeelVariableContext feelContext;
        ParsedExpression parsedExpression = feelExpression.getParsedExpression();
        Either evalResult = this.feelEngine.eval(parsedExpression, (Context)(feelContext = new FeelVariableContext(context)));
        if (evalResult.isLeft()) {
            FeelEngine.Failure failure = (FeelEngine.Failure)evalResult.left().get();
            return new EvaluationFailure(expression, failure.message());
        }
        Object result = evalResult.right().get();
        if (result instanceof Val) {
            return new FeelEvaluationResult(expression, (Val)result, (Function1<Val, DirectBuffer>)((Function1)this.messagePackTransformer::toMessagePack));
        }
        throw new IllegalStateException(String.format("Expected FEEL evaluation result to be of type '%s' but was '%s'", Val.class, result.getClass()));
    }
}

