/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.el.impl.feel;

import io.zeebe.el.impl.Loggers;
import io.zeebe.el.impl.feel.MessagePackContext;
import io.zeebe.msgpack.spec.MsgPackWriter;
import java.io.Serializable;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.camunda.feel.context.Context;
import org.camunda.feel.syntaxtree.Val;
import org.camunda.feel.syntaxtree.ValBoolean;
import org.camunda.feel.syntaxtree.ValContext;
import org.camunda.feel.syntaxtree.ValList;
import org.camunda.feel.syntaxtree.ValNull$;
import org.camunda.feel.syntaxtree.ValNumber;
import org.camunda.feel.syntaxtree.ValString;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.math.BigDecimal;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005i3A\u0001D\u0007\u00011!)q\u0004\u0001C\u0001A!91\u0005\u0001b\u0001\n\u0013!\u0003BB\u0017\u0001A\u0003%Q\u0005C\u0004/\u0001\t\u0007I\u0011B\u0018\t\ra\u0002\u0001\u0015!\u00031\u0011\u001dI\u0004A1A\u0005\niBa!\u0011\u0001!\u0002\u0013Y\u0004b\u0002\"\u0001\u0005\u0004%IA\u000f\u0005\u0007\u0007\u0002\u0001\u000b\u0011B\u001e\t\u000b\u0011\u0003A\u0011A#\t\u000bQ\u0003A\u0011B+\u00039\u0019+W\r\u001c+p\u001b\u0016\u001c8/Y4f!\u0006\u001c7\u000e\u0016:b]N4wN]7fe*\u0011abD\u0001\u0005M\u0016,GN\u0003\u0002\u0011#\u0005!\u0011.\u001c9m\u0015\t\u00112#\u0001\u0002fY*\u0011A#F\u0001\u0006u\u0016,'-\u001a\u0006\u0002-\u0005\u0011\u0011n\\\u0002\u0001'\t\u0001\u0011\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0002\"A\t\u0001\u000e\u00035\taa\u001e:ji\u0016\u0014X#A\u0013\u0011\u0005\u0019ZS\"A\u0014\u000b\u0005!J\u0013\u0001B:qK\u000eT!AK\n\u0002\u000f5\u001cx\r]1dW&\u0011Af\n\u0002\u000e\u001bN<\u0007+Y2l/JLG/\u001a:\u0002\u000f]\u0014\u0018\u000e^3sA\u0005YqO]5uK\n+hMZ3s+\u0005\u0001\u0004CA\u00197\u001b\u0005\u0011$BA\u001a5\u0003\u0019\twM]8oC*\tQ'A\u0002pe\u001eL!a\u000e\u001a\u0003+\u0015C\b/\u00198eC\ndW-\u0011:sCf\u0014UO\u001a4fe\u0006aqO]5uK\n+hMZ3sA\u0005Q!/Z:vYR4\u0016.Z<\u0016\u0003m\u0002\"\u0001P \u000e\u0003uR!A\u0010\u001a\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002A{\taQK\\:bM\u0016\u0014UO\u001a4fe\u0006Y!/Z:vYR4\u0016.Z<!\u00035\u0019HO]5oO^\u0013\u0018\r\u001d9fe\u0006q1\u000f\u001e:j]\u001e<&/\u00199qKJ\u0004\u0013!\u0004;p\u001b\u0016\u001c8/Y4f!\u0006\u001c7\u000e\u0006\u0002G\u0013B\u0011\u0011gR\u0005\u0003\u0011J\u0012A\u0002R5sK\u000e$()\u001e4gKJDQA\u0013\u0006A\u0002-\u000bQA^1mk\u0016\u0004\"\u0001\u0014*\u000e\u00035S!AT(\u0002\u0015MLh\u000e^1yiJ,WM\u0003\u0002\u000f!*\u0011\u0011\u000bN\u0001\bG\u0006lWO\u001c3b\u0013\t\u0019VJA\u0002WC2\f!b\u001e:ji\u00164\u0016\r\\;f)\t1\u0016\f\u0005\u0002\u001b/&\u0011\u0001l\u0007\u0002\u0005+:LG\u000fC\u0003K\u0017\u0001\u00071\n")
public class FeelToMessagePackTransformer {
    private final MsgPackWriter writer = new MsgPackWriter();
    private final ExpandableArrayBuffer writeBuffer = new ExpandableArrayBuffer();
    private final UnsafeBuffer resultView = new UnsafeBuffer();
    private final UnsafeBuffer stringWrapper = new UnsafeBuffer();

    private MsgPackWriter writer() {
        return this.writer;
    }

    private ExpandableArrayBuffer writeBuffer() {
        return this.writeBuffer;
    }

    private UnsafeBuffer resultView() {
        return this.resultView;
    }

    private UnsafeBuffer stringWrapper() {
        return this.stringWrapper;
    }

    public DirectBuffer toMessagePack(Val value) {
        this.writer().wrap((MutableDirectBuffer)this.writeBuffer(), 0);
        this.writeValue(value);
        this.resultView().wrap((DirectBuffer)this.writeBuffer(), 0, this.writer().getOffset());
        return this.resultView();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void writeValue(Val value2) {
        boolean bl = false;
        ValNumber valNumber = null;
        boolean bl2 = false;
        ValContext valContext = null;
        Val val = value2;
        if (ValNull$.MODULE$.equals(val)) {
            this.writer().writeNil();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (val instanceof ValNumber) {
            bl = true;
            valNumber = (ValNumber)val;
            BigDecimal number = valNumber.value();
            if (number.isWhole()) {
                this.writer().writeInteger(number.longValue());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl) {
            BigDecimal number = valNumber.value();
            this.writer().writeFloat(number.doubleValue());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (val instanceof ValBoolean) {
            ValBoolean valBoolean = (ValBoolean)val;
            boolean bl3 = valBoolean.value();
            this.writer().writeBoolean(bl3);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (val instanceof ValString) {
            ValString valString = (ValString)val;
            String string = valString.value();
            this.stringWrapper().wrap(string.getBytes());
            this.writer().writeString((DirectBuffer)this.stringWrapper());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (val instanceof ValList) {
            ValList valList = (ValList)val;
            List items = valList.items();
            this.writer().writeArrayHeader(items.size());
            items.foreach((Function1 & Serializable)value -> {
                this.writeValue(value);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (val instanceof ValContext) {
            bl2 = true;
            valContext = (ValContext)val;
            Context context = valContext.context();
            if (context instanceof MessagePackContext) {
                MessagePackContext messagePackContext = (MessagePackContext)context;
                this.writer().writeRaw(messagePackContext.messagePackMap());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl2) {
            Context context = valContext.context();
            Map variables = context.variableProvider().getVariables();
            this.writer().writeMapHeader(variables.size());
            variables.foreach((Function1 & Serializable)x0$1 -> {
                BoxedUnit boxedUnit;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Object value = tuple2._2();
                    this.stringWrapper().wrap(key.getBytes());
                    this.writer().writeString((DirectBuffer)this.stringWrapper());
                    Object object = value;
                    if (object instanceof Val) {
                        Val val = (Val)object;
                        this.writeValue(val);
                        boxedUnit = BoxedUnit.UNIT;
                    } else if (object instanceof DirectBuffer) {
                        DirectBuffer directBuffer = (DirectBuffer)object;
                        boxedUnit = this.writer().writeRaw(directBuffer);
                    } else {
                        this.writer().writeNil();
                        Loggers.LOGGER.warn("No FEEL to MessagePack transformation for '{}'. Using 'null' for context entry with key '{}'.", object, (Object)key);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return boxedUnit2;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        this.writer().writeNil();
        Loggers.LOGGER.warn("No FEEL to MessagePack transformation for '{}'. Using 'null' instead.", (Object)val);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }
}

