/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.record;

import io.zeebe.protocol.record.Record;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.Intent;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractRecordAssert<S extends AbstractRecordAssert<S, A>, A extends Record>
extends AbstractObjectAssert<S, A> {
    protected AbstractRecordAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasBrokerVersion(String brokerVersion) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting brokerVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualBrokerVersion = ((Record)this.actual).getBrokerVersion();
        if (!Objects.areEqual((Object)actualBrokerVersion, (Object)brokerVersion)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, brokerVersion, actualBrokerVersion});
        }
        return (S)((Object)((AbstractRecordAssert)this.myself));
    }

    public S hasIntent(Intent intent) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting intent of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Intent actualIntent = ((Record)this.actual).getIntent();
        if (!Objects.areEqual((Object)actualIntent, (Object)intent)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, intent, actualIntent});
        }
        return (S)((Object)((AbstractRecordAssert)this.myself));
    }

    public S hasKey(long key) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting key of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualKey = ((Record)this.actual).getKey();
        if (actualKey != key) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, key, actualKey});
        }
        return (S)((Object)((AbstractRecordAssert)this.myself));
    }

    public S hasPartitionId(int partitionId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting partitionId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualPartitionId = ((Record)this.actual).getPartitionId();
        if (actualPartitionId != partitionId) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, partitionId, actualPartitionId});
        }
        return (S)((Object)((AbstractRecordAssert)this.myself));
    }

    public S hasPosition(long position) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting position of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualPosition = ((Record)this.actual).getPosition();
        if (actualPosition != position) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, position, actualPosition});
        }
        return (S)((Object)((AbstractRecordAssert)this.myself));
    }

    public S hasRecordType(RecordType recordType) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting recordType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        RecordType actualRecordType = ((Record)this.actual).getRecordType();
        if (!Objects.areEqual((Object)actualRecordType, (Object)recordType)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, recordType, actualRecordType});
        }
        return (S)((Object)((AbstractRecordAssert)this.myself));
    }

    public S hasRejectionReason(String rejectionReason) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting rejectionReason of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualRejectionReason = ((Record)this.actual).getRejectionReason();
        if (!Objects.areEqual((Object)actualRejectionReason, (Object)rejectionReason)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, rejectionReason, actualRejectionReason});
        }
        return (S)((Object)((AbstractRecordAssert)this.myself));
    }

    public S hasRejectionType(RejectionType rejectionType) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting rejectionType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        RejectionType actualRejectionType = ((Record)this.actual).getRejectionType();
        if (!Objects.areEqual((Object)actualRejectionType, (Object)rejectionType)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, rejectionType, actualRejectionType});
        }
        return (S)((Object)((AbstractRecordAssert)this.myself));
    }

    public S hasSourceRecordPosition(long sourceRecordPosition) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting sourceRecordPosition of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualSourceRecordPosition = ((Record)this.actual).getSourceRecordPosition();
        if (actualSourceRecordPosition != sourceRecordPosition) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, sourceRecordPosition, actualSourceRecordPosition});
        }
        return (S)((Object)((AbstractRecordAssert)this.myself));
    }

    public S hasTimestamp(long timestamp) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting timestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualTimestamp = ((Record)this.actual).getTimestamp();
        if (actualTimestamp != timestamp) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, timestamp, actualTimestamp});
        }
        return (S)((Object)((AbstractRecordAssert)this.myself));
    }

    public S hasValue(RecordValue value) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting value of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        RecordValue actualValue = ((Record)this.actual).getValue();
        if (!Objects.areEqual((Object)actualValue, (Object)value)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, value, actualValue});
        }
        return (S)((Object)((AbstractRecordAssert)this.myself));
    }

    public S hasValueType(ValueType valueType) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting valueType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        ValueType actualValueType = ((Record)this.actual).getValueType();
        if (!Objects.areEqual((Object)actualValueType, (Object)valueType)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, valueType, actualValueType});
        }
        return (S)((Object)((AbstractRecordAssert)this.myself));
    }
}

