/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.record.value;

import io.zeebe.protocol.record.value.DeploymentRecordValue;
import io.zeebe.protocol.record.value.deployment.DeployedWorkflow;
import io.zeebe.protocol.record.value.deployment.DeploymentResource;
import java.util.Collection;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;

public abstract class AbstractDeploymentRecordValueAssert<S extends AbstractDeploymentRecordValueAssert<S, A>, A extends DeploymentRecordValue>
extends AbstractObjectAssert<S, A> {
    protected AbstractDeploymentRecordValueAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasDeployedWorkflows(DeployedWorkflow ... deployedWorkflows) {
        this.isNotNull();
        if (deployedWorkflows == null) {
            this.failWithMessage("Expecting deployedWorkflows parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((DeploymentRecordValue)this.actual).getDeployedWorkflows(), (Object[])deployedWorkflows);
        return (S)((Object)((AbstractDeploymentRecordValueAssert)this.myself));
    }

    public S hasDeployedWorkflows(Collection<? extends DeployedWorkflow> deployedWorkflows) {
        this.isNotNull();
        if (deployedWorkflows == null) {
            this.failWithMessage("Expecting deployedWorkflows parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractDeploymentRecordValueAssert)this.myself));
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((DeploymentRecordValue)this.actual).getDeployedWorkflows(), deployedWorkflows.toArray());
        return (S)((Object)((AbstractDeploymentRecordValueAssert)this.myself));
    }

    public S hasOnlyDeployedWorkflows(DeployedWorkflow ... deployedWorkflows) {
        this.isNotNull();
        if (deployedWorkflows == null) {
            this.failWithMessage("Expecting deployedWorkflows parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((DeploymentRecordValue)this.actual).getDeployedWorkflows(), (Object[])deployedWorkflows);
        return (S)((Object)((AbstractDeploymentRecordValueAssert)this.myself));
    }

    public S hasOnlyDeployedWorkflows(Collection<? extends DeployedWorkflow> deployedWorkflows) {
        this.isNotNull();
        if (deployedWorkflows == null) {
            this.failWithMessage("Expecting deployedWorkflows parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractDeploymentRecordValueAssert)this.myself));
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((DeploymentRecordValue)this.actual).getDeployedWorkflows(), deployedWorkflows.toArray());
        return (S)((Object)((AbstractDeploymentRecordValueAssert)this.myself));
    }

    public S doesNotHaveDeployedWorkflows(DeployedWorkflow ... deployedWorkflows) {
        this.isNotNull();
        if (deployedWorkflows == null) {
            this.failWithMessage("Expecting deployedWorkflows parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((DeploymentRecordValue)this.actual).getDeployedWorkflows(), (Object[])deployedWorkflows);
        return (S)((Object)((AbstractDeploymentRecordValueAssert)this.myself));
    }

    public S doesNotHaveDeployedWorkflows(Collection<? extends DeployedWorkflow> deployedWorkflows) {
        this.isNotNull();
        if (deployedWorkflows == null) {
            this.failWithMessage("Expecting deployedWorkflows parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractDeploymentRecordValueAssert)this.myself));
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((DeploymentRecordValue)this.actual).getDeployedWorkflows(), deployedWorkflows.toArray());
        return (S)((Object)((AbstractDeploymentRecordValueAssert)this.myself));
    }

    public S hasNoDeployedWorkflows() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have deployedWorkflows but had :\n  <%s>";
        if (((DeploymentRecordValue)this.actual).getDeployedWorkflows().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((DeploymentRecordValue)this.actual).getDeployedWorkflows()});
        }
        return (S)((Object)((AbstractDeploymentRecordValueAssert)this.myself));
    }

    public S hasResources(DeploymentResource ... resources) {
        this.isNotNull();
        if (resources == null) {
            this.failWithMessage("Expecting resources parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((DeploymentRecordValue)this.actual).getResources(), (Object[])resources);
        return (S)((Object)((AbstractDeploymentRecordValueAssert)this.myself));
    }

    public S hasResources(Collection<? extends DeploymentResource> resources) {
        this.isNotNull();
        if (resources == null) {
            this.failWithMessage("Expecting resources parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractDeploymentRecordValueAssert)this.myself));
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((DeploymentRecordValue)this.actual).getResources(), resources.toArray());
        return (S)((Object)((AbstractDeploymentRecordValueAssert)this.myself));
    }

    public S hasOnlyResources(DeploymentResource ... resources) {
        this.isNotNull();
        if (resources == null) {
            this.failWithMessage("Expecting resources parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((DeploymentRecordValue)this.actual).getResources(), (Object[])resources);
        return (S)((Object)((AbstractDeploymentRecordValueAssert)this.myself));
    }

    public S hasOnlyResources(Collection<? extends DeploymentResource> resources) {
        this.isNotNull();
        if (resources == null) {
            this.failWithMessage("Expecting resources parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractDeploymentRecordValueAssert)this.myself));
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((DeploymentRecordValue)this.actual).getResources(), resources.toArray());
        return (S)((Object)((AbstractDeploymentRecordValueAssert)this.myself));
    }

    public S doesNotHaveResources(DeploymentResource ... resources) {
        this.isNotNull();
        if (resources == null) {
            this.failWithMessage("Expecting resources parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((DeploymentRecordValue)this.actual).getResources(), (Object[])resources);
        return (S)((Object)((AbstractDeploymentRecordValueAssert)this.myself));
    }

    public S doesNotHaveResources(Collection<? extends DeploymentResource> resources) {
        this.isNotNull();
        if (resources == null) {
            this.failWithMessage("Expecting resources parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractDeploymentRecordValueAssert)this.myself));
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((DeploymentRecordValue)this.actual).getResources(), resources.toArray());
        return (S)((Object)((AbstractDeploymentRecordValueAssert)this.myself));
    }

    public S hasNoResources() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have resources but had :\n  <%s>";
        if (((DeploymentRecordValue)this.actual).getResources().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((DeploymentRecordValue)this.actual).getResources()});
        }
        return (S)((Object)((AbstractDeploymentRecordValueAssert)this.myself));
    }
}

