/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.record.value;

import io.zeebe.protocol.record.value.JobBatchRecordValue;
import io.zeebe.protocol.record.value.JobRecordValue;
import java.util.Collection;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractJobBatchRecordValueAssert<S extends AbstractJobBatchRecordValueAssert<S, A>, A extends JobBatchRecordValue>
extends AbstractObjectAssert<S, A> {
    protected AbstractJobBatchRecordValueAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasJobKeys(Long ... jobKeys) {
        this.isNotNull();
        if (jobKeys == null) {
            this.failWithMessage("Expecting jobKeys parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getJobKeys(), (Object[])jobKeys);
        return (S)((Object)((AbstractJobBatchRecordValueAssert)this.myself));
    }

    public S hasJobKeys(Collection<? extends Long> jobKeys) {
        this.isNotNull();
        if (jobKeys == null) {
            this.failWithMessage("Expecting jobKeys parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractJobBatchRecordValueAssert)this.myself));
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getJobKeys(), jobKeys.toArray());
        return (S)((Object)((AbstractJobBatchRecordValueAssert)this.myself));
    }

    public S hasOnlyJobKeys(Long ... jobKeys) {
        this.isNotNull();
        if (jobKeys == null) {
            this.failWithMessage("Expecting jobKeys parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getJobKeys(), (Object[])jobKeys);
        return (S)((Object)((AbstractJobBatchRecordValueAssert)this.myself));
    }

    public S hasOnlyJobKeys(Collection<? extends Long> jobKeys) {
        this.isNotNull();
        if (jobKeys == null) {
            this.failWithMessage("Expecting jobKeys parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractJobBatchRecordValueAssert)this.myself));
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getJobKeys(), jobKeys.toArray());
        return (S)((Object)((AbstractJobBatchRecordValueAssert)this.myself));
    }

    public S doesNotHaveJobKeys(Long ... jobKeys) {
        this.isNotNull();
        if (jobKeys == null) {
            this.failWithMessage("Expecting jobKeys parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getJobKeys(), (Object[])jobKeys);
        return (S)((Object)((AbstractJobBatchRecordValueAssert)this.myself));
    }

    public S doesNotHaveJobKeys(Collection<? extends Long> jobKeys) {
        this.isNotNull();
        if (jobKeys == null) {
            this.failWithMessage("Expecting jobKeys parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractJobBatchRecordValueAssert)this.myself));
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getJobKeys(), jobKeys.toArray());
        return (S)((Object)((AbstractJobBatchRecordValueAssert)this.myself));
    }

    public S hasNoJobKeys() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have jobKeys but had :\n  <%s>";
        if (((JobBatchRecordValue)this.actual).getJobKeys().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((JobBatchRecordValue)this.actual).getJobKeys()});
        }
        return (S)((Object)((AbstractJobBatchRecordValueAssert)this.myself));
    }

    public S hasJobs(JobRecordValue ... jobs) {
        this.isNotNull();
        if (jobs == null) {
            this.failWithMessage("Expecting jobs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getJobs(), (Object[])jobs);
        return (S)((Object)((AbstractJobBatchRecordValueAssert)this.myself));
    }

    public S hasJobs(Collection<? extends JobRecordValue> jobs) {
        this.isNotNull();
        if (jobs == null) {
            this.failWithMessage("Expecting jobs parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractJobBatchRecordValueAssert)this.myself));
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getJobs(), jobs.toArray());
        return (S)((Object)((AbstractJobBatchRecordValueAssert)this.myself));
    }

    public S hasOnlyJobs(JobRecordValue ... jobs) {
        this.isNotNull();
        if (jobs == null) {
            this.failWithMessage("Expecting jobs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getJobs(), (Object[])jobs);
        return (S)((Object)((AbstractJobBatchRecordValueAssert)this.myself));
    }

    public S hasOnlyJobs(Collection<? extends JobRecordValue> jobs) {
        this.isNotNull();
        if (jobs == null) {
            this.failWithMessage("Expecting jobs parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractJobBatchRecordValueAssert)this.myself));
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getJobs(), jobs.toArray());
        return (S)((Object)((AbstractJobBatchRecordValueAssert)this.myself));
    }

    public S doesNotHaveJobs(JobRecordValue ... jobs) {
        this.isNotNull();
        if (jobs == null) {
            this.failWithMessage("Expecting jobs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getJobs(), (Object[])jobs);
        return (S)((Object)((AbstractJobBatchRecordValueAssert)this.myself));
    }

    public S doesNotHaveJobs(Collection<? extends JobRecordValue> jobs) {
        this.isNotNull();
        if (jobs == null) {
            this.failWithMessage("Expecting jobs parameter not to be null.", new Object[0]);
            return (S)((Object)((AbstractJobBatchRecordValueAssert)this.myself));
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getJobs(), jobs.toArray());
        return (S)((Object)((AbstractJobBatchRecordValueAssert)this.myself));
    }

    public S hasNoJobs() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have jobs but had :\n  <%s>";
        if (((JobBatchRecordValue)this.actual).getJobs().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((JobBatchRecordValue)this.actual).getJobs()});
        }
        return (S)((Object)((AbstractJobBatchRecordValueAssert)this.myself));
    }

    public S hasMaxJobsToActivate(int maxJobsToActivate) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting maxJobsToActivate of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualMaxJobsToActivate = ((JobBatchRecordValue)this.actual).getMaxJobsToActivate();
        if (actualMaxJobsToActivate != maxJobsToActivate) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, maxJobsToActivate, actualMaxJobsToActivate});
        }
        return (S)((Object)((AbstractJobBatchRecordValueAssert)this.myself));
    }

    public S hasTimeout(long timeout) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting timeout of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualTimeout = ((JobBatchRecordValue)this.actual).getTimeout();
        if (actualTimeout != timeout) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, timeout, actualTimeout});
        }
        return (S)((Object)((AbstractJobBatchRecordValueAssert)this.myself));
    }

    public S isTruncated() {
        this.isNotNull();
        if (!((JobBatchRecordValue)this.actual).isTruncated()) {
            this.failWithMessage("\nExpecting that actual JobBatchRecordValue is truncated but is not.", new Object[0]);
        }
        return (S)((Object)((AbstractJobBatchRecordValueAssert)this.myself));
    }

    public S isNotTruncated() {
        this.isNotNull();
        if (((JobBatchRecordValue)this.actual).isTruncated()) {
            this.failWithMessage("\nExpecting that actual JobBatchRecordValue is not truncated but is.", new Object[0]);
        }
        return (S)((Object)((AbstractJobBatchRecordValueAssert)this.myself));
    }

    public S hasType(String type) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualType = ((JobBatchRecordValue)this.actual).getType();
        if (!Objects.areEqual((Object)actualType, (Object)type)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, type, actualType});
        }
        return (S)((Object)((AbstractJobBatchRecordValueAssert)this.myself));
    }

    public S hasWorker(String worker) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting worker of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualWorker = ((JobBatchRecordValue)this.actual).getWorker();
        if (!Objects.areEqual((Object)actualWorker, (Object)worker)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, worker, actualWorker});
        }
        return (S)((Object)((AbstractJobBatchRecordValueAssert)this.myself));
    }
}

