/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.record.value.deployment;

import io.zeebe.protocol.record.value.deployment.DeployedWorkflow;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractDeployedWorkflowAssert<S extends AbstractDeployedWorkflowAssert<S, A>, A extends DeployedWorkflow>
extends AbstractObjectAssert<S, A> {
    protected AbstractDeployedWorkflowAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasBpmnProcessId(String bpmnProcessId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting bpmnProcessId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualBpmnProcessId = ((DeployedWorkflow)this.actual).getBpmnProcessId();
        if (!Objects.areEqual((Object)actualBpmnProcessId, (Object)bpmnProcessId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, bpmnProcessId, actualBpmnProcessId});
        }
        return (S)((Object)((AbstractDeployedWorkflowAssert)this.myself));
    }

    public S hasResourceName(String resourceName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting resourceName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualResourceName = ((DeployedWorkflow)this.actual).getResourceName();
        if (!Objects.areEqual((Object)actualResourceName, (Object)resourceName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, resourceName, actualResourceName});
        }
        return (S)((Object)((AbstractDeployedWorkflowAssert)this.myself));
    }

    public S hasVersion(int version) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting version of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualVersion = ((DeployedWorkflow)this.actual).getVersion();
        if (actualVersion != version) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, version, actualVersion});
        }
        return (S)((Object)((AbstractDeployedWorkflowAssert)this.myself));
    }

    public S hasWorkflowKey(long workflowKey) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting workflowKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualWorkflowKey = ((DeployedWorkflow)this.actual).getWorkflowKey();
        if (actualWorkflowKey != workflowKey) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, workflowKey, actualWorkflowKey});
        }
        return (S)((Object)((AbstractDeployedWorkflowAssert)this.myself));
    }
}

