/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.record.value.deployment;

import io.zeebe.protocol.record.value.deployment.DeploymentResource;
import io.zeebe.protocol.record.value.deployment.ResourceType;
import java.util.Arrays;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;

public abstract class AbstractDeploymentResourceAssert<S extends AbstractDeploymentResourceAssert<S, A>, A extends DeploymentResource>
extends AbstractObjectAssert<S, A> {
    protected AbstractDeploymentResourceAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasResource(byte ... resource) {
        this.isNotNull();
        if (resource == null) {
            this.failWithMessage("Expecting resource parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((DeploymentResource)this.actual).getResource()).contains(resource);
        return (S)((Object)((AbstractDeploymentResourceAssert)this.myself));
    }

    public S hasOnlyResource(byte ... resource) {
        this.isNotNull();
        if (resource == null) {
            this.failWithMessage("Expecting resource parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((DeploymentResource)this.actual).getResource()).containsOnly(resource);
        return (S)((Object)((AbstractDeploymentResourceAssert)this.myself));
    }

    public S doesNotHaveResource(byte ... resource) {
        this.isNotNull();
        if (resource == null) {
            this.failWithMessage("Expecting resource parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((DeploymentResource)this.actual).getResource()).doesNotContain(resource);
        return (S)((Object)((AbstractDeploymentResourceAssert)this.myself));
    }

    public S hasNoResource() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have resource but had :\n  <%s>";
        if (((DeploymentResource)this.actual).getResource().length > 0) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, Arrays.toString(((DeploymentResource)this.actual).getResource())});
        }
        return (S)((Object)((AbstractDeploymentResourceAssert)this.myself));
    }

    public S hasResourceName(String resourceName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting resourceName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualResourceName = ((DeploymentResource)this.actual).getResourceName();
        if (!Objects.areEqual((Object)actualResourceName, (Object)resourceName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, resourceName, actualResourceName});
        }
        return (S)((Object)((AbstractDeploymentResourceAssert)this.myself));
    }

    public S hasResourceType(ResourceType resourceType) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting resourceType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        ResourceType actualResourceType = ((DeploymentResource)this.actual).getResourceType();
        if (!Objects.areEqual((Object)actualResourceType, (Object)resourceType)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, resourceType, actualResourceType});
        }
        return (S)((Object)((AbstractDeploymentResourceAssert)this.myself));
    }
}

