/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.monitor;

import io.zeebe.monitor.zeebe.ZeebeConnectionService;
import io.zeebe.monitor.zeebe.ZeebeHazelcastService;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.data.web.config.EnableSpringDataWebSupport;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@SpringBootApplication
@EnableScheduling
@EnableAsync
@EnableSpringDataWebSupport
public class ZeebeSimpleMonitorApp {
    private static final Logger LOG = LoggerFactory.getLogger(ZeebeSimpleMonitorApp.class);
    @Value(value="${io.zeebe.monitor.connectionString}")
    private String connectionString;
    @Value(value="${io.zeebe.monitor.hazelcast.connection}")
    private String hazelcastConnection;
    @Autowired
    private ZeebeConnectionService connectionService;
    @Autowired
    private ZeebeHazelcastService hazelcastService;

    public static void main(String ... args) {
        SpringApplication.run(ZeebeSimpleMonitorApp.class, (String[])args);
    }

    @PostConstruct
    public void initConnection() {
        this.connectionService.connect(this.connectionString);
        if (this.connectionService.isConnected()) {
            this.onConnected();
        } else {
            this.tryConnecting();
        }
    }

    private void onConnected() {
        this.hazelcastService.start(this.hazelcastConnection);
    }

    private void tryConnecting() {
        if (this.connectionService.checkConnection()) {
            this.onConnected();
        } else {
            this.scheduledExecutor().schedule(() -> this.tryConnecting(), 100L, TimeUnit.MILLISECONDS);
        }
    }

    @PreDestroy
    public void close() {
        this.connectionService.disconnect();
        this.hazelcastService.close();
    }

    @Bean
    public ScheduledExecutorService scheduledExecutor() {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        return executor;
    }

    @Bean
    public Executor asyncExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(1);
        executor.setMaxPoolSize(1);
        executor.setQueueCapacity(32);
        executor.initialize();
        return executor;
    }
}

