/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.monitor.rest;

import io.zeebe.client.ZeebeClient;
import io.zeebe.client.api.response.ActivateJobsResponse;
import io.zeebe.client.api.response.ActivatedJob;
import io.zeebe.monitor.entity.JobEntity;
import io.zeebe.monitor.repository.JobRepository;
import io.zeebe.monitor.zeebe.ZeebeConnectionService;
import java.time.Duration;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/jobs"})
public class JobResource {
    private static final String WORKER_NAME = "zeebe-simple-monitor";
    @Autowired
    private ZeebeConnectionService connections;
    @Autowired
    private JobRepository jobRepository;

    @RequestMapping(path={"/{key}/complete"}, method={RequestMethod.PUT})
    public void completeJob(@PathVariable(value="key") long key, @RequestBody String variables) {
        ZeebeClient client = this.connections.getClient();
        ActivatedJob activatedJob = this.activateJob(key, client);
        client.newCompleteCommand(activatedJob.getKey()).variables(variables).send().join();
    }

    @RequestMapping(path={"/{key}/fail"}, method={RequestMethod.PUT})
    public void failJob(@PathVariable(value="key") long key) {
        ZeebeClient client = this.connections.getClient();
        ActivatedJob activatedJob = this.activateJob(key, client);
        client.newFailCommand(activatedJob.getKey()).retries(0).errorMessage("Failed by user.").send().join();
    }

    private ActivatedJob activateJob(long key, ZeebeClient client) {
        JobEntity job = (JobEntity)this.jobRepository.findByKey(key).orElseThrow(() -> new RuntimeException("no job found with key: " + key));
        String jobType = job.getJobType();
        return this.activateJob(client, key, jobType);
    }

    private ActivatedJob activateJob(ZeebeClient client, long key, String jobType) {
        List jobs = ((ActivateJobsResponse)client.newActivateJobsCommand().jobType(jobType).maxJobsToActivate(10).timeout(Duration.ofSeconds(10L)).workerName(WORKER_NAME).send().join()).getJobs();
        if (jobs.isEmpty()) {
            throw new RuntimeException("no activatable job found with key: " + key);
        }
        return jobs.stream().filter(activatedJob -> activatedJob.getKey() == key).findFirst().orElseGet(() -> this.activateJob(client, key, jobType));
    }
}

