/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.monitor.rest;

import io.zeebe.model.bpmn.Bpmn;
import io.zeebe.model.bpmn.BpmnModelInstance;
import io.zeebe.model.bpmn.instance.ConditionExpression;
import io.zeebe.model.bpmn.instance.FlowElement;
import io.zeebe.model.bpmn.instance.SequenceFlow;
import io.zeebe.model.bpmn.instance.ServiceTask;
import io.zeebe.model.bpmn.instance.zeebe.ZeebeTaskDefinition;
import io.zeebe.monitor.entity.ElementInstanceEntity;
import io.zeebe.monitor.entity.ElementInstanceStatistics;
import io.zeebe.monitor.entity.IncidentEntity;
import io.zeebe.monitor.entity.JobEntity;
import io.zeebe.monitor.entity.MessageEntity;
import io.zeebe.monitor.entity.MessageSubscriptionEntity;
import io.zeebe.monitor.entity.TimerEntity;
import io.zeebe.monitor.entity.VariableEntity;
import io.zeebe.monitor.entity.WorkflowEntity;
import io.zeebe.monitor.entity.WorkflowInstanceEntity;
import io.zeebe.monitor.repository.ElementInstanceRepository;
import io.zeebe.monitor.repository.IncidentRepository;
import io.zeebe.monitor.repository.JobRepository;
import io.zeebe.monitor.repository.MessageRepository;
import io.zeebe.monitor.repository.MessageSubscriptionRepository;
import io.zeebe.monitor.repository.TimerRepository;
import io.zeebe.monitor.repository.VariableRepository;
import io.zeebe.monitor.repository.WorkflowInstanceRepository;
import io.zeebe.monitor.repository.WorkflowRepository;
import io.zeebe.monitor.rest.ActiveScope;
import io.zeebe.monitor.rest.AuditLogEntry;
import io.zeebe.monitor.rest.BpmnElementInfo;
import io.zeebe.monitor.rest.CalledWorkflowInstanceDto;
import io.zeebe.monitor.rest.ElementInstanceState;
import io.zeebe.monitor.rest.IncidentDto;
import io.zeebe.monitor.rest.IncidentListDto;
import io.zeebe.monitor.rest.JobDto;
import io.zeebe.monitor.rest.MessageDto;
import io.zeebe.monitor.rest.MessageSubscriptionDto;
import io.zeebe.monitor.rest.TimerDto;
import io.zeebe.monitor.rest.VariableEntry;
import io.zeebe.monitor.rest.VariableUpdateEntry;
import io.zeebe.monitor.rest.ViewController;
import io.zeebe.monitor.rest.WorkflowDto;
import io.zeebe.monitor.rest.WorkflowInstanceDto;
import io.zeebe.monitor.rest.WorkflowInstanceListDto;
import io.zeebe.protocol.record.value.BpmnElementType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@Controller
public class ViewController {
    private static final List<String> WORKFLOW_INSTANCE_ENTERED_INTENTS = Arrays.asList("ELEMENT_ACTIVATED");
    private static final List<String> WORKFLOW_INSTANCE_COMPLETED_INTENTS = Arrays.asList("ELEMENT_COMPLETED", "ELEMENT_TERMINATED");
    private static final List<String> EXCLUDE_ELEMENT_TYPES = Arrays.asList(BpmnElementType.MULTI_INSTANCE_BODY.name());
    private static final List<String> JOB_COMPLETED_INTENTS = Arrays.asList("completed", "canceled");
    @Autowired
    private WorkflowRepository workflowRepository;
    @Autowired
    private WorkflowInstanceRepository workflowInstanceRepository;
    @Autowired
    private ElementInstanceRepository activityInstanceRepository;
    @Autowired
    private IncidentRepository incidentRepository;
    @Autowired
    private JobRepository jobRepository;
    @Autowired
    private MessageRepository messageRepository;
    @Autowired
    private MessageSubscriptionRepository messageSubscriptionRepository;
    @Autowired
    private TimerRepository timerRepository;
    @Autowired
    private VariableRepository variableRepository;

    @GetMapping(value={"/"})
    public String index(Map<String, Object> model, Pageable pageable) {
        return this.workflowList(model, pageable);
    }

    @GetMapping(value={"/views/workflows"})
    public String workflowList(Map<String, Object> model, Pageable pageable) {
        long count = this.workflowRepository.count();
        ArrayList<WorkflowDto> workflows = new ArrayList<WorkflowDto>();
        for (WorkflowEntity workflowEntity : this.workflowRepository.findAll(pageable)) {
            WorkflowDto dto = this.toDto(workflowEntity);
            workflows.add(dto);
        }
        model.put("workflows", workflows);
        model.put("count", count);
        this.addPaginationToModel(model, pageable, count);
        return "workflow-list-view";
    }

    private WorkflowDto toDto(WorkflowEntity workflowEntity) {
        long workflowKey = workflowEntity.getKey();
        long running = this.workflowInstanceRepository.countByWorkflowKeyAndEndIsNull(workflowKey);
        long ended = this.workflowInstanceRepository.countByWorkflowKeyAndEndIsNotNull(workflowKey);
        WorkflowDto dto = WorkflowDto.from((WorkflowEntity)workflowEntity, (long)running, (long)ended);
        return dto;
    }

    @GetMapping(value={"/views/workflows/{key}"})
    @Transactional
    public String workflowDetail(@PathVariable long key, Map<String, Object> model, Pageable pageable) {
        WorkflowEntity workflow = (WorkflowEntity)this.workflowRepository.findByKey(key).orElseThrow(() -> new RuntimeException("No workflow found with key: " + key));
        model.put("workflow", this.toDto(workflow));
        model.put("resource", workflow.getResource());
        List elementInstanceStates = this.getElementInstanceStates(key);
        model.put("instance.elementInstances", elementInstanceStates);
        long count = this.workflowInstanceRepository.countByWorkflowKey(key);
        ArrayList<WorkflowInstanceListDto> instances = new ArrayList<WorkflowInstanceListDto>();
        for (WorkflowInstanceEntity instanceEntity : this.workflowInstanceRepository.findByWorkflowKey(key, pageable)) {
            instances.add(this.toDto(instanceEntity));
        }
        model.put("instances", instances);
        model.put("count", count);
        List timers = this.timerRepository.findByWorkflowKeyAndWorkflowInstanceKeyIsNull(Long.valueOf(key)).stream().map(arg_0 -> this.toDto(arg_0)).collect(Collectors.toList());
        model.put("timers", timers);
        List messageSubscriptions = this.messageSubscriptionRepository.findByWorkflowKeyAndWorkflowInstanceKeyIsNull(key).stream().map(arg_0 -> this.toDto(arg_0)).collect(Collectors.toList());
        model.put("messageSubscriptions", messageSubscriptions);
        ByteArrayInputStream resourceAsStream = new ByteArrayInputStream(workflow.getResource().getBytes());
        BpmnModelInstance bpmn = Bpmn.readModelFromStream((InputStream)resourceAsStream);
        model.put("instance.bpmnElementInfos", this.getBpmnElementInfos(bpmn));
        this.addPaginationToModel(model, pageable, count);
        return "workflow-detail-view";
    }

    private List<ElementInstanceState> getElementInstanceStates(long key) {
        List elementEnteredStatistics = this.workflowRepository.getElementInstanceStatisticsByKeyAndIntentIn(key, (Collection)WORKFLOW_INSTANCE_ENTERED_INTENTS, (Collection)EXCLUDE_ELEMENT_TYPES);
        Map<String, Long> elementCompletedCount = this.workflowRepository.getElementInstanceStatisticsByKeyAndIntentIn(key, (Collection)WORKFLOW_INSTANCE_COMPLETED_INTENTS, (Collection)EXCLUDE_ELEMENT_TYPES).stream().collect(Collectors.toMap(ElementInstanceStatistics::getElementId, ElementInstanceStatistics::getCount));
        List<ElementInstanceState> elementInstanceStates = elementEnteredStatistics.stream().map(s -> {
            ElementInstanceState state = new ElementInstanceState();
            String elementId = s.getElementId();
            state.setElementId(elementId);
            long completedInstances = elementCompletedCount.getOrDefault(elementId, 0L);
            long enteredInstances = s.getCount();
            state.setActiveInstances(enteredInstances - completedInstances);
            state.setEndedInstances(completedInstances);
            return state;
        }).collect(Collectors.toList());
        return elementInstanceStates;
    }

    private WorkflowInstanceListDto toDto(WorkflowInstanceEntity instance) {
        WorkflowInstanceListDto dto = new WorkflowInstanceListDto();
        dto.setWorkflowInstanceKey(instance.getKey());
        dto.setBpmnProcessId(instance.getBpmnProcessId());
        dto.setWorkflowKey(instance.getWorkflowKey());
        boolean isEnded = instance.getEnd() != null && instance.getEnd() > 0L;
        dto.setState(instance.getState());
        dto.setStartTime(Instant.ofEpochMilli(instance.getStart()).toString());
        if (isEnded) {
            dto.setEndTime(Instant.ofEpochMilli(instance.getEnd()).toString());
        }
        return dto;
    }

    @GetMapping(value={"/views/instances"})
    public String instanceList(Map<String, Object> model, Pageable pageable) {
        long count = this.workflowInstanceRepository.count();
        ArrayList<WorkflowInstanceListDto> instances = new ArrayList<WorkflowInstanceListDto>();
        for (WorkflowInstanceEntity instanceEntity : this.workflowInstanceRepository.findAll(pageable)) {
            WorkflowInstanceListDto dto = this.toDto(instanceEntity);
            instances.add(dto);
        }
        model.put("instances", instances);
        model.put("count", count);
        this.addPaginationToModel(model, pageable, count);
        return "instance-list-view";
    }

    @GetMapping(value={"/views/instances/{key}"})
    @Transactional
    public String instanceDetail(@PathVariable long key, Map<String, Object> model, Pageable pageable) {
        WorkflowInstanceEntity instance = (WorkflowInstanceEntity)this.workflowInstanceRepository.findByKey(key).orElseThrow(() -> new RuntimeException("No workflow instance found with key: " + key));
        this.workflowRepository.findByKey(instance.getWorkflowKey()).ifPresent(workflow -> model.put("resource", workflow.getResource()));
        model.put("instance", this.toInstanceDto(instance));
        return "instance-detail-view";
    }

    private WorkflowInstanceDto toInstanceDto(WorkflowInstanceEntity instance) {
        List<ElementInstanceEntity> events = StreamSupport.stream(this.activityInstanceRepository.findByWorkflowInstanceKey(instance.getKey()).spliterator(), false).collect(Collectors.toList());
        WorkflowInstanceDto dto = new WorkflowInstanceDto();
        dto.setWorkflowInstanceKey(instance.getKey());
        dto.setPartitionId(instance.getPartitionId());
        dto.setWorkflowKey(instance.getWorkflowKey());
        dto.setBpmnProcessId(instance.getBpmnProcessId());
        dto.setVersion(instance.getVersion());
        boolean isEnded = instance.getEnd() != null && instance.getEnd() > 0L;
        dto.setState(instance.getState());
        dto.setRunning(!isEnded);
        dto.setStartTime(Instant.ofEpochMilli(instance.getStart()).toString());
        if (isEnded) {
            dto.setEndTime(Instant.ofEpochMilli(instance.getEnd()).toString());
        }
        if (instance.getParentElementInstanceKey() > 0L) {
            dto.setParentWorkflowInstanceKey(instance.getParentWorkflowInstanceKey());
            this.workflowInstanceRepository.findByKey(instance.getParentWorkflowInstanceKey().longValue()).ifPresent(parent -> dto.setParentBpmnProcessId(parent.getBpmnProcessId()));
        }
        List completedActivities = events.stream().filter(e -> WORKFLOW_INSTANCE_COMPLETED_INTENTS.contains(e.getIntent())).map(ElementInstanceEntity::getElementId).collect(Collectors.toList());
        List activeActivities = events.stream().filter(e -> WORKFLOW_INSTANCE_ENTERED_INTENTS.contains(e.getIntent())).map(ElementInstanceEntity::getElementId).filter(id -> !completedActivities.contains(id)).collect(Collectors.toList());
        dto.setActiveActivities(activeActivities);
        List takenSequenceFlows = events.stream().filter(e -> e.getIntent().equals("SEQUENCE_FLOW_TAKEN")).map(ElementInstanceEntity::getElementId).collect(Collectors.toList());
        dto.setTakenSequenceFlows(takenSequenceFlows);
        Map<String, Long> completedElementsById = events.stream().filter(e -> WORKFLOW_INSTANCE_COMPLETED_INTENTS.contains(e.getIntent())).filter(e -> !EXCLUDE_ELEMENT_TYPES.contains(e.getBpmnElementType())).collect(Collectors.groupingBy(ElementInstanceEntity::getElementId, Collectors.counting()));
        Map<String, Long> enteredElementsById = events.stream().filter(e -> WORKFLOW_INSTANCE_ENTERED_INTENTS.contains(e.getIntent())).filter(e -> !EXCLUDE_ELEMENT_TYPES.contains(e.getBpmnElementType())).collect(Collectors.groupingBy(ElementInstanceEntity::getElementId, Collectors.counting()));
        List elementStates = enteredElementsById.entrySet().stream().map(e -> {
            String elementId = (String)e.getKey();
            long enteredInstances = (Long)e.getValue();
            long completedInstances = completedElementsById.getOrDefault(elementId, 0L);
            ElementInstanceState state = new ElementInstanceState();
            state.setElementId(elementId);
            state.setActiveInstances(enteredInstances - completedInstances);
            state.setEndedInstances(completedInstances);
            return state;
        }).collect(Collectors.toList());
        dto.setElementInstances(elementStates);
        Optional<BpmnModelInstance> bpmnModelInstance = this.workflowRepository.findByKey(instance.getWorkflowKey()).map(w -> new ByteArrayInputStream(w.getResource().getBytes())).map(stream -> Bpmn.readModelFromStream((InputStream)stream));
        HashMap flowElements = new HashMap();
        bpmnModelInstance.ifPresent(bpmn -> {
            bpmn.getModelElementsByType(FlowElement.class).forEach(e -> flowElements.put(e.getId(), Optional.ofNullable(e.getName()).orElse("")));
            dto.setBpmnElementInfos(this.getBpmnElementInfos(bpmn));
        });
        List auditLogEntries = events.stream().map(e -> {
            AuditLogEntry entry = new AuditLogEntry();
            entry.setKey(e.getKey());
            entry.setFlowScopeKey(e.getFlowScopeKey());
            entry.setElementId(e.getElementId());
            entry.setElementName(flowElements.getOrDefault(e.getElementId(), ""));
            entry.setBpmnElementType(e.getBpmnElementType());
            entry.setState(e.getIntent());
            entry.setTimestamp(Instant.ofEpochMilli(e.getTimestamp()).toString());
            return entry;
        }).collect(Collectors.toList());
        dto.setAuditLogEntries(auditLogEntries);
        List incidents = StreamSupport.stream(this.incidentRepository.findByWorkflowInstanceKey(instance.getKey()).spliterator(), false).collect(Collectors.toList());
        HashMap<Long, String> elementIdsForKeys = new HashMap<Long, String>();
        elementIdsForKeys.put(instance.getKey(), instance.getBpmnProcessId());
        events.forEach(e -> elementIdsForKeys.put(e.getKey(), e.getElementId()));
        List incidentDtos = incidents.stream().map(i -> {
            long incidentKey = i.getKey();
            IncidentDto incidentDto = new IncidentDto();
            incidentDto.setKey(incidentKey);
            incidentDto.setElementId((String)elementIdsForKeys.get(i.getElementInstanceKey()));
            incidentDto.setElementInstanceKey(i.getElementInstanceKey());
            if (i.getJobKey() > 0L) {
                incidentDto.setJobKey(Long.valueOf(i.getJobKey()));
            }
            incidentDto.setErrorType(i.getErrorType());
            incidentDto.setErrorMessage(i.getErrorMessage());
            boolean isResolved = i.getResolved() != null && i.getResolved() > 0L;
            incidentDto.setResolved(isResolved);
            incidentDto.setCreatedTime(Instant.ofEpochMilli(i.getCreated()).toString());
            if (isResolved) {
                incidentDto.setResolvedTime(Instant.ofEpochMilli(i.getResolved()).toString());
                incidentDto.setState("Resolved");
            } else {
                incidentDto.setState("Created");
            }
            return incidentDto;
        }).collect(Collectors.toList());
        dto.setIncidents(incidentDtos);
        List activitiesWitIncidents = incidents.stream().filter(i -> i.getResolved() == null || i.getResolved() <= 0L).map(i -> (String)elementIdsForKeys.get(i.getElementInstanceKey())).distinct().collect(Collectors.toList());
        dto.setIncidentActivities(activitiesWitIncidents);
        activeActivities.removeAll(activitiesWitIncidents);
        dto.setActiveActivities(activeActivities);
        Map<VariableTuple, List<VariableEntity>> variablesByScopeAndName = this.variableRepository.findByWorkflowInstanceKey(instance.getKey()).stream().collect(Collectors.groupingBy(v -> new VariableTuple(v.getScopeKey(), v.getName())));
        variablesByScopeAndName.forEach((scopeKeyName, variables) -> {
            VariableEntry variableDto = new VariableEntry();
            long scopeKey = scopeKeyName.scopeKey;
            variableDto.setScopeKey(scopeKey);
            variableDto.setScopeName((String)elementIdsForKeys.get(scopeKey));
            variableDto.setName(scopeKeyName.name);
            VariableEntity lastUpdate = (VariableEntity)variables.get(variables.size() - 1);
            variableDto.setValue(lastUpdate.getValue());
            variableDto.setTimestamp(Instant.ofEpochMilli(lastUpdate.getTimestamp()).toString());
            List varUpdates = variables.stream().map(v -> {
                VariableUpdateEntry varUpdate = new VariableUpdateEntry();
                varUpdate.setValue(v.getValue());
                varUpdate.setTimestamp(Instant.ofEpochMilli(v.getTimestamp()).toString());
                return varUpdate;
            }).collect(Collectors.toList());
            variableDto.setUpdates(varUpdates);
            dto.getVariables().add(variableDto);
        });
        ArrayList<Object> activeScopes = new ArrayList<Object>();
        if (!isEnded) {
            activeScopes.add(new ActiveScope(instance.getKey(), instance.getBpmnProcessId()));
            List completedElementInstances = events.stream().filter(e -> WORKFLOW_INSTANCE_COMPLETED_INTENTS.contains(e.getIntent())).map(ElementInstanceEntity::getKey).collect(Collectors.toList());
            List activeElementInstances = events.stream().filter(e -> WORKFLOW_INSTANCE_ENTERED_INTENTS.contains(e.getIntent())).map(ElementInstanceEntity::getKey).filter(id -> !completedElementInstances.contains(id)).map(scopeKey -> new ActiveScope(scopeKey.longValue(), (String)elementIdsForKeys.get(scopeKey))).collect(Collectors.toList());
            activeScopes.addAll(activeElementInstances);
        }
        dto.setActiveScopes(activeScopes);
        List jobDtos = this.jobRepository.findByWorkflowInstanceKey(instance.getKey()).stream().map(job -> {
            JobDto jobDto = this.toDto(job);
            jobDto.setElementId(elementIdsForKeys.getOrDefault(job.getElementInstanceKey(), ""));
            boolean isActivatable = job.getRetries() > 0 && Arrays.asList("created", "failed", "timed_out", "retries_updated").contains(job.getState());
            jobDto.setActivatable(isActivatable);
            return jobDto;
        }).collect(Collectors.toList());
        dto.setJobs(jobDtos);
        List messageSubscriptions = this.messageSubscriptionRepository.findByWorkflowInstanceKey(instance.getKey()).stream().map(subscription -> {
            MessageSubscriptionDto subscriptionDto = this.toDto(subscription);
            subscriptionDto.setElementId(elementIdsForKeys.getOrDefault(subscriptionDto.getElementInstanceKey(), ""));
            return subscriptionDto;
        }).collect(Collectors.toList());
        dto.setMessageSubscriptions(messageSubscriptions);
        List timers = this.timerRepository.findByWorkflowInstanceKey(Long.valueOf(instance.getKey())).stream().map(timer -> this.toDto(timer)).collect(Collectors.toList());
        dto.setTimers(timers);
        List calledWorkflowInstances = this.workflowInstanceRepository.findByParentWorkflowInstanceKey(instance.getKey()).stream().map(childEntity -> {
            CalledWorkflowInstanceDto childDto = new CalledWorkflowInstanceDto();
            childDto.setChildWorkflowInstanceKey(childEntity.getKey());
            childDto.setChildBpmnProcessId(childEntity.getBpmnProcessId());
            childDto.setChildState(childEntity.getState());
            childDto.setElementInstanceKey(childEntity.getParentElementInstanceKey().longValue());
            String callElementId = elementIdsForKeys.getOrDefault(childEntity.getParentElementInstanceKey(), "");
            childDto.setElementId(callElementId);
            return childDto;
        }).collect(Collectors.toList());
        dto.setCalledWorkflowInstances(calledWorkflowInstances);
        return dto;
    }

    private List<BpmnElementInfo> getBpmnElementInfos(BpmnModelInstance bpmn) {
        ArrayList<BpmnElementInfo> infos = new ArrayList<BpmnElementInfo>();
        bpmn.getModelElementsByType(ServiceTask.class).forEach(t -> {
            BpmnElementInfo info = new BpmnElementInfo();
            info.setElementId(t.getId());
            String jobType = ((ZeebeTaskDefinition)t.getSingleExtensionElement(ZeebeTaskDefinition.class)).getType();
            info.setInfo("job-type: " + jobType);
            infos.add(info);
        });
        bpmn.getModelElementsByType(SequenceFlow.class).forEach(s -> {
            ConditionExpression conditionExpression = s.getConditionExpression();
            if (conditionExpression != null && !conditionExpression.getTextContent().isEmpty()) {
                BpmnElementInfo info = new BpmnElementInfo();
                info.setElementId(s.getId());
                String condition = conditionExpression.getTextContent();
                info.setInfo("condition: " + condition);
                infos.add(info);
            }
        });
        return infos;
    }

    @GetMapping(value={"/views/incidents"})
    public String incidentList(Map<String, Object> model, Pageable pageable) {
        long count = this.incidentRepository.countByResolvedIsNull();
        ArrayList<IncidentListDto> incidents = new ArrayList<IncidentListDto>();
        for (IncidentEntity incidentEntity : this.incidentRepository.findByResolvedIsNull(pageable)) {
            IncidentListDto dto = this.toDto(incidentEntity);
            incidents.add(dto);
        }
        model.put("incidents", incidents);
        model.put("count", count);
        this.addPaginationToModel(model, pageable, count);
        return "incident-list-view";
    }

    private IncidentListDto toDto(IncidentEntity incident) {
        IncidentListDto dto = new IncidentListDto();
        dto.setKey(incident.getKey());
        dto.setBpmnProcessId(incident.getBpmnProcessId());
        dto.setWorkflowKey(incident.getWorkflowKey());
        dto.setWorkflowInstanceKey(incident.getWorkflowInstanceKey());
        dto.setErrorType(incident.getErrorType());
        dto.setErrorMessage(incident.getErrorMessage());
        boolean isResolved = incident.getResolved() != null && incident.getResolved() > 0L;
        dto.setCreatedTime(Instant.ofEpochMilli(incident.getCreated()).toString());
        if (isResolved) {
            dto.setResolvedTime(Instant.ofEpochMilli(incident.getResolved()).toString());
            dto.setState("Resolved");
        } else {
            dto.setState("Created");
        }
        return dto;
    }

    @GetMapping(value={"/views/jobs"})
    public String jobList(Map<String, Object> model, Pageable pageable) {
        long count = this.jobRepository.countByStateNotIn((Collection)JOB_COMPLETED_INTENTS);
        ArrayList<JobDto> dtos = new ArrayList<JobDto>();
        for (JobEntity jobEntity : this.jobRepository.findByStateNotIn((Collection)JOB_COMPLETED_INTENTS, pageable)) {
            JobDto dto = this.toDto(jobEntity);
            dtos.add(dto);
        }
        model.put("jobs", dtos);
        model.put("count", count);
        this.addPaginationToModel(model, pageable, count);
        return "job-list-view";
    }

    private JobDto toDto(JobEntity job) {
        JobDto dto = new JobDto();
        dto.setKey(job.getKey());
        dto.setJobType(job.getJobType());
        dto.setWorkflowInstanceKey(job.getWorkflowInstanceKey());
        dto.setElementInstanceKey(job.getElementInstanceKey());
        dto.setState(job.getState());
        dto.setRetries(job.getRetries());
        Optional.ofNullable(job.getWorker()).ifPresent(arg_0 -> ((JobDto)dto).setWorker(arg_0));
        dto.setTimestamp(Instant.ofEpochMilli(job.getTimestamp()).toString());
        return dto;
    }

    @GetMapping(value={"/views/messages"})
    public String messageList(Map<String, Object> model, Pageable pageable) {
        long count = this.messageRepository.count();
        ArrayList<MessageDto> dtos = new ArrayList<MessageDto>();
        for (MessageEntity messageEntity : this.messageRepository.findAll(pageable)) {
            MessageDto dto = this.toDto(messageEntity);
            dtos.add(dto);
        }
        model.put("messages", dtos);
        model.put("count", count);
        this.addPaginationToModel(model, pageable, count);
        return "message-list-view";
    }

    private MessageDto toDto(MessageEntity message) {
        MessageDto dto = new MessageDto();
        dto.setKey(message.getKey());
        dto.setName(message.getName());
        dto.setCorrelationKey(message.getCorrelationKey());
        dto.setMessageId(message.getMessageId());
        dto.setPayload(message.getPayload());
        dto.setState(message.getState());
        dto.setTimestamp(Instant.ofEpochMilli(message.getTimestamp()).toString());
        return dto;
    }

    private MessageSubscriptionDto toDto(MessageSubscriptionEntity subscription) {
        MessageSubscriptionDto dto = new MessageSubscriptionDto();
        dto.setKey(subscription.getId());
        dto.setMessageName(subscription.getMessageName());
        dto.setCorrelationKey(Optional.ofNullable(subscription.getCorrelationKey()).orElse(""));
        dto.setWorkflowInstanceKey(subscription.getWorkflowInstanceKey());
        dto.setElementInstanceKey(subscription.getElementInstanceKey());
        dto.setElementId(subscription.getTargetFlowNodeId());
        dto.setState(subscription.getState());
        dto.setTimestamp(Instant.ofEpochMilli(subscription.getTimestamp()).toString());
        dto.setOpen(subscription.getState().equals("opened"));
        return dto;
    }

    private TimerDto toDto(TimerEntity timer) {
        TimerDto dto = new TimerDto();
        dto.setElementId(timer.getTargetFlowNodeId());
        dto.setState(timer.getState());
        dto.setDueDate(Instant.ofEpochMilli(timer.getDueDate()).toString());
        dto.setTimestamp(Instant.ofEpochMilli(timer.getTimestamp()).toString());
        dto.setElementInstanceKey(timer.getElementInstanceKey());
        int repetitions = timer.getRepetitions();
        dto.setRepetitions(repetitions >= 0 ? String.valueOf(repetitions) : "\u221e");
        return dto;
    }

    private void addPaginationToModel(Map<String, Object> model, Pageable pageable, long count) {
        int currentPage = pageable.getPageNumber();
        model.put("page", currentPage + 1);
        if (currentPage > 0) {
            model.put("prevPage", currentPage - 1);
        }
        if (count > (long)((1 + currentPage) * pageable.getPageSize())) {
            model.put("nextPage", currentPage + 1);
        }
    }
}

