/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.monitor.rest;

import io.zeebe.client.ZeebeClient;
import io.zeebe.monitor.rest.ResolveIncidentDto;
import io.zeebe.monitor.zeebe.ZeebeConnectionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/instances"})
public class WorkflowInstanceResource {
    @Autowired
    private ZeebeConnectionService connections;

    @RequestMapping(path={"/{key}"}, method={RequestMethod.DELETE})
    public void cancelWorkflowInstance(@PathVariable(value="key") long key) throws Exception {
        this.connections.getClient().newCancelInstanceCommand(key).send().join();
    }

    @RequestMapping(path={"/{key}/set-variables"}, method={RequestMethod.PUT})
    public void setVariables(@PathVariable(value="key") long key, @RequestBody String payload) throws Exception {
        this.connections.getClient().newSetVariablesCommand(key).variables(payload).send().join();
    }

    @RequestMapping(path={"/{key}/set-variables-local"}, method={RequestMethod.PUT})
    public void setVariablesLocal(@PathVariable(value="key") long key, @RequestBody String payload) throws Exception {
        this.connections.getClient().newSetVariablesCommand(key).variables(payload).local(true).send().join();
    }

    @RequestMapping(path={"/{key}/resolve-incident"}, method={RequestMethod.PUT})
    public void resolveIncident(@PathVariable(value="key") long key, @RequestBody ResolveIncidentDto dto) throws Exception {
        ZeebeClient client = this.connections.getClient();
        if (dto.getJobKey() != null && dto.getJobKey() > 0L) {
            client.newUpdateRetriesCommand(dto.getJobKey().longValue()).retries(dto.getRemainingRetries()).send().join();
        }
        client.newResolveIncidentCommand(key).send().join();
    }
}

