/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.monitor.rest;

import io.zeebe.client.ZeebeClient;
import io.zeebe.client.api.command.DeployWorkflowCommandStep1;
import io.zeebe.monitor.rest.DeploymentDto;
import io.zeebe.monitor.rest.FileDto;
import io.zeebe.monitor.zeebe.ZeebeConnectionService;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/workflows"})
public class WorkflowResource {
    @Autowired
    private ZeebeConnectionService connections;

    @RequestMapping(path={"/{workflowKey}"}, method={RequestMethod.POST})
    public void createWorkflowInstance(@PathVariable(value="workflowKey") long workflowKey, @RequestBody String payload) {
        this.connections.getClient().newCreateInstanceCommand().workflowKey(workflowKey).variables(payload).send().join();
    }

    @RequestMapping(path={"/"}, method={RequestMethod.POST})
    public void uploadModel(@RequestBody DeploymentDto deployment) throws UnsupportedEncodingException {
        ZeebeClient client = this.connections.getClient();
        List files = deployment.getFiles();
        if (files.isEmpty()) {
            throw new RuntimeException("no resources to deploy");
        }
        FileDto firstFile = (FileDto)files.get(0);
        DeployWorkflowCommandStep1.DeployWorkflowCommandBuilderStep2 cmd = client.newDeployCommand().addResourceBytes(firstFile.getContent(), firstFile.getFilename());
        for (FileDto file : files.subList(1, files.size())) {
            cmd.addResourceBytes(file.getContent(), file.getFilename());
        }
        cmd.send().join();
    }
}

