/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.monitor.zeebe;

import io.zeebe.client.ZeebeClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ZeebeConnectionService {
    private static final Logger LOG = LoggerFactory.getLogger(ZeebeConnectionService.class);
    private ZeebeClient client;
    private boolean connected = false;

    public void connect(String connectionString) {
        LOG.info("Connecting to broker '{}'", (Object)connectionString);
        this.client = ZeebeClient.newClientBuilder().brokerContactPoint(connectionString).usePlaintext().build();
        if (this.checkConnection()) {
            LOG.info("connected to '{}'", (Object)connectionString);
        } else {
            LOG.warn("Failed to connect to '{}'", (Object)connectionString);
        }
    }

    public ZeebeClient getClient() {
        if (this.client != null) {
            return this.client;
        }
        throw new RuntimeException("Monitor is not connected");
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean checkConnection() {
        if (this.client != null) {
            try {
                this.client.newTopologyRequest().send().join();
                if (!this.connected) {
                    LOG.info("connected to '{}'", (Object)this.client.getConfiguration().getBrokerContactPoint());
                }
                this.connected = true;
            }
            catch (Exception e) {
                this.connected = false;
            }
        }
        return this.connected;
    }

    public void disconnect() {
        LOG.info("disconnect");
        this.client.close();
        this.connected = false;
        this.client = null;
    }
}

