/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.monitor.zeebe;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.core.HazelcastInstance;
import io.zeebe.hazelcast.connect.java.ZeebeHazelcast;
import io.zeebe.monitor.zeebe.ZeebeConnectionService;
import io.zeebe.monitor.zeebe.ZeebeImportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ZeebeHazelcastService {
    private static final Logger LOG = LoggerFactory.getLogger(ZeebeConnectionService.class);
    @Autowired
    private ZeebeImportService importService;
    private HazelcastInstance hazelcast;

    public void start(String hazelcastConnection) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().addAddress(new String[]{hazelcastConnection});
        LOG.info("Connecting to Hazelcast '{}'", (Object)hazelcastConnection);
        this.hazelcast = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        ZeebeHazelcast zeebeHazelcast = new ZeebeHazelcast(this.hazelcast);
        LOG.info("Importing records from Hazelcast...");
        this.importService.importFrom(zeebeHazelcast);
    }

    public void close() {
        if (this.hazelcast != null) {
            this.hazelcast.shutdown();
        }
    }
}

